/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_16_R3;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileEntityHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import io.lumine.mythic.core.volatilecode.v1_16_R3.CompoundTag_v1_16_R3;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.items.ItemFactory;
import io.lumine.mythic.utils.numbers.Numbers;
import java.util.HashSet;
import net.minecraft.server.v1_16_R3.BaseBlockPosition;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.DataWatcher;
import net.minecraft.server.v1_16_R3.DataWatcherObject;
import net.minecraft.server.v1_16_R3.DataWatcherRegistry;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityArmorStand;
import net.minecraft.server.v1_16_R3.EntityItem;
import net.minecraft.server.v1_16_R3.EntityLightning;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutCloseWindow;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityStatus;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R3.PacketPlayOutGameStateChange;
import net.minecraft.server.v1_16_R3.PacketPlayOutPosition;
import net.minecraft.server.v1_16_R3.PacketPlayOutSetSlot;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutWorldBorder;
import net.minecraft.server.v1_16_R3.PlayerConnection;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldBorder;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftItem;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class VolatileEntityHandler_v1_16_R3
implements VolatileEntityHandler {
    public VolatileEntityHandler_v1_16_R3(VolatileCodeHandler handler) {
    }

    @Override
    public void setCustomName(AbstractEntity entity, String name) {
        entity.getBukkitEntity().setCustomName(name);
    }

    @Override
    public float getEntityAbsorptionHearts(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return 0.0f;
        }
        EntityLiving el = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
        return el.getAbsorptionHearts();
    }

    @Override
    public void setEntityAbsorptionHearts(AbstractEntity entity, float value) {
        if (!entity.isLiving()) {
            return;
        }
        EntityLiving el = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
        el.setAbsorptionHearts(value);
    }

    @Override
    public void setLocation(AbstractEntity entity, AbstractLocation location) {
    }

    @Override
    public void setLocation(AbstractEntity entity, double x, double y, double z, float yaw, float pitch) {
    }

    @Override
    public void setLocation(AbstractEntity entity, double x, double y, double z, float yaw, float pitch, boolean noRotation, boolean noGravity) {
        Entity e = ((CraftEntity)entity.getBukkitEntity()).getHandle();
        e.setLocation(x, y, z, yaw, pitch);
        if (entity.isPlayer()) {
            this.playerConnectionTeleport(entity, x, y, z, yaw, pitch, noRotation, noGravity);
        }
        if (e.world instanceof WorldServer) {
            ((WorldServer)e.world).entityJoinedWorld(e);
        }
    }

    @Override
    public void setPlayerRotation(AbstractPlayer entity, float yaw, float pitch) {
        EntityPlayer me = ((CraftPlayer)entity.getBukkitEntity()).getHandle();
        HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags> set = new HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags>();
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.X);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.Y);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.Z);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.X_ROT);
        set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.Y_ROT);
        me.playerConnection.sendPacket((Packet)new PacketPlayOutPosition(0.0, 0.0, 0.0, yaw, pitch, set, 0));
    }

    private void playerConnectionTeleport(AbstractEntity entity, double x, double y, double z, float yaw, float pitch, boolean noRotation, boolean noGravity) {
        EntityPlayer me = ((CraftPlayer)entity.getBukkitEntity()).getHandle();
        HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags> set = new HashSet<PacketPlayOutPosition.EnumPlayerTeleportFlags>();
        if (noRotation) {
            pitch = 0.0f;
            yaw = 0.0f;
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.X_ROT);
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.Y_ROT);
        }
        if (noGravity) {
            set.add(PacketPlayOutPosition.EnumPlayerTeleportFlags.Y);
            y = 0.0;
        }
        me.playerConnection.sendPacket((Packet)new PacketPlayOutPosition(x, y, z, yaw, pitch, set, 0));
    }

    @Override
    public boolean isEntityInMotion(AbstractEntity entity, boolean exact) {
        if (entity.isLiving()) {
            EntityLiving e = (EntityLiving)((CraftEntity)entity.getBukkitEntity()).getHandle();
            Vec3D position = e.getPositionVector();
            if (exact) {
                if (e.lastX != position.getX() || e.lastY != position.getY() || e.lastZ != position.getZ()) {
                    return true;
                }
            } else {
                int x = Numbers.floor(e.lastX);
                int y = Numbers.floor(e.lastY);
                int z = Numbers.floor(e.lastZ);
                int pX = Numbers.floor(position.getX());
                int pY = Numbers.floor(position.getY());
                int pZ = Numbers.floor(position.getZ());
                if (x != pX || y != pY || z != pZ) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void setHitBox(AbstractEntity target, double a0, double a1, double a2) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        Entity me = ((CraftEntity)entity).getHandle();
        me.getBoundingBox().a(a0, a1, a2);
    }

    @Override
    public void setItemPosition(AbstractEntity target, AbstractLocation ol) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        if (entity instanceof Item) {
            Item item = (Item)entity;
            EntityItem ei = (EntityItem)((CraftItem)item).getHandle();
            ei.setPosition(ol.getX(), ol.getY(), ol.getZ());
        }
    }

    @Override
    public void sendEntityTeleportPacket(AbstractEntity target) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        Entity me = ((CraftEntity)entity).getHandle();
        PacketPlayOutEntityTeleport tp = new PacketPlayOutEntityTeleport(me);
        entity.getLocation().getWorld().getNearbyEntities(entity.getLocation(), 32.0, 32.0, 32.0).forEach(e -> {
            if (e instanceof Player) {
                ((CraftPlayer)e).getHandle().playerConnection.sendPacket((Packet)tp);
            }
        });
    }

    @Override
    public void setEntityRotation(AbstractEntity target, float pitch, float yaw) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        Entity me = ((CraftEntity)entity).getHandle();
        me.pitch = pitch;
        me.yaw = yaw;
    }

    @Override
    public void setArmorStandNoGravity(AbstractEntity target) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        if (entity.getType() == EntityType.ARMOR_STAND) {
            EntityArmorStand as = (EntityArmorStand)((CraftEntity)entity).getHandle();
            as.setNoGravity(true);
        }
    }

    @Override
    public void sendGameStateChange(AbstractPlayer target, int state, int skybox) {
        Player player = BukkitAdapter.adapt(target);
        PacketPlayOutGameStateChange packet = new PacketPlayOutGameStateChange(new PacketPlayOutGameStateChange.a(state), (float)skybox);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }

    @Override
    public void forcePlayCredits(AbstractPlayer target, float f) {
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.playerConnection.sendPacket((Packet)new PacketPlayOutGameStateChange(new PacketPlayOutGameStateChange.a(4), f));
    }

    @Override
    public void forceCloseWindow(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        me.playerConnection.sendPacket((Packet)new PacketPlayOutCloseWindow(0));
    }

    @Override
    public void setPlayerWorldBorder(AbstractPlayer target, AbstractLocation center, int radius) {
        WorldBorder border;
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer ep = ((CraftPlayer)player).getHandle();
        if (radius == -1) {
            border = ep.world.getWorldBorder();
        } else {
            border = new WorldBorder();
            border.world = ep.world.getWorldBorder().world;
            border.setCenter(center.getX(), center.getZ());
            border.setSize((double)radius);
            border.setWarningDistance(1);
        }
        ep.playerConnection.sendPacket((Packet)new PacketPlayOutWorldBorder(border, PacketPlayOutWorldBorder.EnumWorldBorderAction.INITIALIZE));
    }

    @Override
    public void sendPlayerFakeInventoryItem(AbstractPlayer target, org.bukkit.inventory.ItemStack stack, int slot) {
        if (slot < 9) {
            slot += 36;
        }
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        ItemStack item = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)stack);
        PacketPlayOutSetSlot packet = new PacketPlayOutSetSlot(0, slot, item);
        entityPlayer.playerConnection.sendPacket((Packet)packet);
    }

    public void hideEntityModel(AbstractEntity target) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        Entity me = ((CraftEntity)entity).getHandle();
        DataWatcher w = me.getDataWatcher();
        w.set(new DataWatcherObject(0, DataWatcherRegistry.a), (Object)32);
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata(me.getId(), w, true);
    }

    @Override
    public void playTotemEffect(AbstractPlayer target, int model) {
        this.sendPlayerFakeInventoryItem(target, ItemFactory.of(Material.TOTEM_OF_UNDYING).model(model).build(), 45);
        Player player = BukkitAdapter.adapt(target);
        EntityPlayer me = ((CraftPlayer)player).getHandle();
        PacketPlayOutEntityStatus packet = new PacketPlayOutEntityStatus((Entity)me, 35);
        me.playerConnection.sendPacket((Packet)packet);
        player.stopSound(Sound.ITEM_TOTEM_USE, SoundCategory.MASTER);
        Schedulers.async().runLater(() -> this.sendPlayerFakeInventoryItem(target, player.getInventory().getItemInOffHand(), 45), 1L);
    }

    @Override
    public void setEntitySpawnReason(AbstractEntity target, CreatureSpawnEvent.SpawnReason reason) {
        org.bukkit.entity.Entity entity = BukkitAdapter.adapt(target);
        org.bukkit.World world = BukkitAdapter.adapt(target.getWorld());
        Entity entityHandle = ((CraftEntity)entity).getHandle();
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        worldHandle.addEntity(entityHandle, reason);
    }

    @Override
    public void spawnFakeLightning(AbstractLocation target, double radius) {
        Location location = BukkitAdapter.adapt(target);
        org.bukkit.World world = location.getWorld();
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        EntityLightning entitylightning = (EntityLightning)EntityTypes.LIGHTNING_BOLT.a((World)worldHandle);
        entitylightning.d(Vec3D.c((BaseBlockPosition)new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
        entitylightning.setEffect(true);
        PacketPlayOutSpawnEntity spawnItem = new PacketPlayOutSpawnEntity((Entity)entitylightning);
        double distanceSquared = radius * radius;
        Schedulers.async().run(() -> {
            for (Player player : location.getWorld().getPlayers()) {
                if (!(location.distanceSquared(player.getLocation()) <= distanceSquared)) continue;
                ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)spawnItem);
                player.playSound(location, "entity.lightning_bolt.impact", 1.0f, 1.0f);
                player.playSound(location, "entity.lightning_bolt.thunder", 10000.0f, 63.0f);
            }
        });
    }

    @Override
    public AbstractEntity addNBTData(AbstractEntity entity, String key, Tag value) {
        CompoundTag compound = this.getNBTData(entity).createBuilder().put(key, value).build();
        this.setNBTData(entity, compound);
        return entity;
    }

    @Override
    public CompoundTag getNBTData(AbstractEntity entity) {
        org.bukkit.entity.Entity bukkitEntity = entity.getBukkitEntity();
        NBTTagCompound compound = new NBTTagCompound();
        return CompoundTag_v1_16_R3.fromNMSTag(compound);
    }

    @Override
    public AbstractEntity setNBTData(AbstractEntity entity, CompoundTag compoundTag) {
        org.bukkit.entity.Entity bukkitEntity = entity.getBukkitEntity();
        return entity;
    }

    @Override
    public void sendActionBarMessageToPlayer(AbstractPlayer target, String message) {
        Player player = BukkitAdapter.adapt(target);
        PlayerConnection conn = ((CraftPlayer)player).getHandle().playerConnection;
    }
}

