/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_18_R2;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileWorldHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.numbers.Numbers;
import io.lumine.mythic.utils.reflection.Reflector;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class VolatileWorldHandler_v1_18_R2
implements VolatileWorldHandler {
    public Thread resetServerThread;

    public VolatileWorldHandler_v1_18_R2(VolatileCodeHandler handler) {
    }

    @Override
    public void registerWorldAccess(org.bukkit.World world) {
    }

    @Override
    public void unregisterWorldAccess(org.bukkit.World world) {
    }

    @Override
    public void playSoundAtLocation(AbstractLocation location, String sound, float volume, float pitch, double radius) {
        Location l = BukkitAdapter.adapt(location);
        l.getWorld().playSound(l, sound, volume, pitch);
    }

    @Override
    public boolean isChunkLoaded(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        return null != nmsWorld.getChunkIfLoaded(x, z);
    }

    @Override
    public int getEntitiesInChunk(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        Chunk chunk = nmsWorld.getChunkIfLoaded(x, z);
        if (chunk == null) {
            return 0;
        }
        return chunk.bukkitChunk.getEntities().length;
    }

    @Override
    public void doBlockTossEffect(AbstractLocation target, Material material, AbstractVector velocity, int duration, boolean hideSourceBlock) {
        Location location = BukkitAdapter.adapt(target);
        BlockPosition blockPosition = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        CraftWorld bukkitWorld = (CraftWorld)location.getWorld();
        WorldServer nmsWorld = bukkitWorld.getHandle();
        IBlockData blockState = material == null ? nmsWorld.a_(blockPosition) : ((CraftBlockData)Bukkit.createBlockData((Material)material)).getState();
        try {
            Constructor<EntityFallingBlock> ref = Reflector.getConstructor(EntityFallingBlock.class, World.class, Double.class, Double.class, Double.class, BlockData.class);
            ref.setAccessible(true);
            EntityFallingBlock block = ref.newInstance(nmsWorld, (double)target.getBlockX() + 0.5, target.getBlockY() + 1, (double)target.getBlockZ() + 0.5, blockState);
            PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)block, block.ad(), BlockBell.i((IBlockData)blockState), blockPosition);
            PacketPlayOutEntityVelocity packetV = new PacketPlayOutEntityVelocity(block.ae(), new Vec3D(velocity.getX(), velocity.getY(), velocity.getZ()));
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (hideSourceBlock) {
                    p.sendBlockChange(location, Material.AIR, (byte)0);
                }
                ((CraftPlayer)p).getHandle().b.a((Packet)packet);
                ((CraftPlayer)p).getHandle().b.a((Packet)packetV);
                Schedulers.async().runLater(() -> {
                    PacketPlayOutEntityDestroy packet2 = new PacketPlayOutEntityDestroy(new int[]{block.ae()});
                    ((CraftPlayer)p).getHandle().b.a((Packet)packet2);
                    if (hideSourceBlock) {
                        p.sendBlockChange(location, location.getBlock().getBlockData());
                    }
                }, duration);
            }
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public float getDifficultyScale(AbstractLocation location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        DifficultyDamageScaler scaler = ((CraftWorld)location.getWorld()).getHandle().d_(pos);
        return scaler.b();
    }

    @Override
    public Collection<AbstractEntity> getEntitiesNearLocation(AbstractLocation location, double radius, Predicate<AbstractEntity> predicate) {
        ArrayList<AbstractEntity> entities = new ArrayList<AbstractEntity>();
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(location.getWorld());
        WorldServer nmsWorld = bukkitWorld.getHandle();
        int smallX = Numbers.floor((location.getX() - radius) / 16.0);
        int bigX = Numbers.floor((location.getX() + radius) / 16.0);
        int smallZ = Numbers.floor((location.getZ() - radius) / 16.0);
        int bigZ = Numbers.floor((location.getZ() + radius) / 16.0);
        for (int x = smallX; x <= bigX; ++x) {
            for (int z = smallZ; z <= bigZ; ++z) {
                Chunk chunk = nmsWorld.getChunkIfLoaded(x, z);
                if (null == chunk) continue;
                for (Entity e : chunk.bukkitChunk.getEntities()) {
                    AbstractEntity entity = BukkitAdapter.adapt(e);
                    if (predicate != null && !predicate.test(entity)) continue;
                    entities.add(entity);
                }
            }
        }
        return entities;
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> filter) {
        Validate.notNull((Object)start, (String)"Start location is null!");
        start.checkFinite();
        Validate.notNull((Object)direction, (String)"Direction is null!");
        direction.checkFinite();
        Validate.isTrue((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude is 0!");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection entities = start.getWorld().getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    @Override
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> entityFilter, Predicate<Material> blockFilter) {
        double distance;
        if (direction.lengthSquared() < 1.0E-5 || maxDistance <= 1.0E-5) {
            return null;
        }
        RayTraceResult blockRayTrace = null;
        RayTraceResult entityRayTrace = start.getWorld().rayTraceEntities(start, direction, maxDistance, raySize, entityFilter);
        if (entityRayTrace != null && entityRayTrace.getHitEntity() != null) {
            distance = start.distance(entityRayTrace.getHitEntity().getLocation());
            if (distance == 0.0) {
                distance = maxDistance;
            }
        } else {
            distance = maxDistance;
        }
        BlockIterator bIterator = new BlockIterator(start.getWorld(), start.toVector(), direction, 0.0, (int)Math.ceil(distance));
        Block block = null;
        while (bIterator.hasNext()) {
            RayTraceResult res;
            block = bIterator.next();
            if (block.isEmpty() || blockFilter.test(block.getType()) || (res = block.rayTrace(start, direction, distance, FluidCollisionMode.ALWAYS)) == null) continue;
            blockRayTrace = res;
            break;
        }
        if (entityRayTrace != null && entityRayTrace.getHitEntity() != null) {
            if (blockRayTrace != null) {
                return blockRayTrace;
            }
            return entityRayTrace;
        }
        if (blockRayTrace != null) {
            return blockRayTrace;
        }
        return new RayTraceResult(block.getLocation().toVector());
    }

    @Override
    public void changeWorldServerThread(org.bukkit.World world) {
    }

    @Override
    public void restoreWorldServerThread(org.bukkit.World world) {
    }

    @Override
    public Entity spawnInvisibleArmorStand(Location location) {
        WorldServer w = ((CraftWorld)location.getWorld()).getHandle();
        EntityArmorStand nmsEntity = new EntityArmorStand((World)w, location.getX(), location.getY(), location.getZ());
        nmsEntity.a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        nmsEntity.j(true);
        w.b((net.minecraft.world.entity.Entity)nmsEntity);
        return nmsEntity.getBukkitEntity();
    }
}

