/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils;

import io.lumine.mythic.utils.plugin.LoaderUtils;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;

public final class Services {
    @Nonnull
    public static <T> T load(@Nonnull Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return Services.get(clazz).orElseThrow(() -> new IllegalStateException("No registration present for service '" + clazz.getName() + "'"));
    }

    @Nonnull
    public static <T> Optional<T> get(@Nonnull Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        RegisteredServiceProvider registration = Bukkit.getServicesManager().getRegistration(clazz);
        if (registration == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(registration.getProvider());
    }

    @Nonnull
    public static <T> T provide(@Nonnull Class<T> clazz, @Nonnull T instance, @Nonnull Plugin plugin, @Nonnull ServicePriority priority) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(instance, "instance");
        Objects.requireNonNull(plugin, "plugin");
        Objects.requireNonNull(priority, "priority");
        Bukkit.getServicesManager().register(clazz, instance, plugin, priority);
        return instance;
    }

    @Nonnull
    public static <T> T provide(@Nonnull Class<T> clazz, @Nonnull T instance, @Nonnull ServicePriority priority) {
        return Services.provide(clazz, instance, (Plugin)LoaderUtils.getPlugin(), priority);
    }

    @Nonnull
    public static <T> T provide(@Nonnull Class<T> clazz, @Nonnull T instance) {
        return Services.provide(clazz, instance, ServicePriority.Normal);
    }

    private Services() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

