/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.adventure.identity;

import io.lumine.mythic.utils.adventure.identity.Identities;
import io.lumine.mythic.utils.adventure.identity.IdentityImpl;
import io.lumine.mythic.utils.adventure.key.Key;
import io.lumine.mythic.utils.adventure.pointer.Pointer;
import io.lumine.mythic.utils.adventure.text.Component;
import io.lumine.mythic.utils.text.examination.Examinable;
import io.lumine.mythic.utils.text.examination.ExaminableProperty;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public interface Identity
extends Examinable {
    public static final Pointer<String> NAME = Pointer.pointer(String.class, Key.key("adventure", "name"));
    public static final Pointer<UUID> UUID = Pointer.pointer(UUID.class, Key.key("adventure", "uuid"));
    public static final Pointer<Component> DISPLAY_NAME = Pointer.pointer(Component.class, Key.key("adventure", "display_name"));
    public static final Pointer<Locale> LOCALE = Pointer.pointer(Locale.class, Key.key("adventure", "locale"));

    @NotNull
    public static Identity nil() {
        return Identities.NIL;
    }

    @NotNull
    public static Identity identity(@NotNull UUID uuid) {
        if (uuid.equals(Identities.NIL.uuid())) {
            return Identities.NIL;
        }
        return new IdentityImpl(uuid);
    }

    @NotNull
    public UUID uuid();

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("uuid", this.uuid()));
    }
}

