/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.adventure.text.format;

import io.lumine.mythic.utils.adventure.text.format.Style;
import io.lumine.mythic.utils.adventure.text.format.StyleBuilderApplicable;
import io.lumine.mythic.utils.adventure.text.format.TextDecorationAndState;
import io.lumine.mythic.utils.adventure.text.format.TextDecorationAndStateImpl;
import io.lumine.mythic.utils.adventure.text.format.TextFormat;
import io.lumine.mythic.utils.adventure.util.Index;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TextDecoration implements StyleBuilderApplicable,
TextFormat
{
    OBFUSCATED("obfuscated"),
    BOLD("bold"),
    STRIKETHROUGH("strikethrough"),
    UNDERLINED("underlined"),
    ITALIC("italic");

    public static final Index<String, TextDecoration> NAMES;
    private final String name;

    private TextDecoration(String name) {
        this.name = name;
    }

    @NotNull
    public final TextDecorationAndState as(boolean state) {
        return this.as(State.byBoolean(state));
    }

    @NotNull
    public final TextDecorationAndState as(@NotNull State state) {
        return new TextDecorationAndStateImpl(this, state);
    }

    @Override
    public void styleApply(@NotNull Style.Builder style) {
        style.decorate(this);
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    static {
        NAMES = Index.create(TextDecoration.class, constant -> constant.name);
    }

    public static enum State {
        NOT_SET("not_set"),
        FALSE("false"),
        TRUE("true");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public static State byBoolean(boolean flag) {
            return flag ? TRUE : FALSE;
        }

        @NotNull
        public static State byBoolean(@Nullable Boolean flag) {
            return flag == null ? NOT_SET : State.byBoolean((boolean)flag);
        }
    }
}

