/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.adventure.text.minimessage.transformation;

import io.lumine.mythic.utils.adventure.text.ComponentLike;
import io.lumine.mythic.utils.adventure.text.minimessage.Context;
import io.lumine.mythic.utils.adventure.text.minimessage.Template;
import io.lumine.mythic.utils.adventure.text.minimessage.parser.ParsingException;
import io.lumine.mythic.utils.adventure.text.minimessage.parser.Token;
import io.lumine.mythic.utils.adventure.text.minimessage.transformation.OneTimeTransformation;
import io.lumine.mythic.utils.adventure.text.minimessage.transformation.Transformation;
import io.lumine.mythic.utils.adventure.text.minimessage.transformation.TransformationType;
import io.lumine.mythic.utils.adventure.text.minimessage.transformation.inbuild.TemplateTransformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TransformationRegistry {
    public static final TransformationRegistry EMPTY = new TransformationRegistry();
    private final List<TransformationType<? extends Transformation>> types = new ArrayList<TransformationType<? extends Transformation>>();

    public TransformationRegistry() {
        this.register(TransformationType.COLOR);
        this.register(TransformationType.DECORATION);
        this.register(TransformationType.HOVER_EVENT);
        this.register(TransformationType.CLICK_EVENT);
        this.register(TransformationType.KEYBIND);
        this.register(TransformationType.TRANSLATABLE);
        this.register(TransformationType.INSERTION);
        this.register(TransformationType.FONT);
        this.register(TransformationType.GRADIENT);
        this.register(TransformationType.RAINBOW);
        this.register(TransformationType.RESET);
        this.register(TransformationType.PRE);
    }

    @SafeVarargs
    public TransformationRegistry(TransformationType<? extends Transformation> ... types) {
        for (TransformationType<? extends Transformation> type : types) {
            this.register(type);
        }
    }

    public void clear() {
        this.types.clear();
    }

    public <T extends Transformation> void register(TransformationType<T> type) {
        this.types.add(type);
    }

    public @Nullable Transformation get(String name, List<Token> inners, Map<String, Template.ComponentTemplate> templates, Function<String, ComponentLike> placeholderResolver, Context context) {
        ComponentLike potentialTemplate = placeholderResolver.apply(name);
        if (potentialTemplate != null) {
            return this.tryLoad(new TemplateTransformation(new Template.ComponentTemplate(name, potentialTemplate.asComponent())), name, inners, context);
        }
        for (TransformationType<? extends Transformation> type : this.types) {
            if (type.canParse.test(name)) {
                return this.tryLoad((Transformation)type.parser.parse(), name, inners, context);
            }
            if (!templates.containsKey(name)) continue;
            return this.tryLoad(new TemplateTransformation(templates.get(name)), name, inners, context);
        }
        return null;
    }

    private Transformation tryLoad(Transformation transformation, String name, List<Token> inners, Context context) {
        try {
            transformation.context(context);
            transformation.load(name, inners);
            return transformation;
        }
        catch (ParsingException exception) {
            if (context.isStrict()) {
                throw exception;
            }
            ArrayList<String> errorMessage = new ArrayList<String>(Arrays.asList("[MiniMessage] Encountered parse exception while trying to load " + transformation.getClass().getSimpleName(), "\tmsg=" + exception.getMessage(), "\twith name=" + name + " and inners=" + inners + "", "\tinput=" + context.ogMessage()));
            if (context.replacedMessage() != null) {
                errorMessage.add("\twith placeholders=" + context.replacedMessage());
            }
            if (inners != null && inners.isEmpty()) {
                errorMessage.add("\thint: did you mean to enter '</" + name + ">'?");
            }
            context.miniMessage().parsingErrorMessageConsumer().accept(errorMessage);
            return null;
        }
    }

    public boolean exists(String name) {
        for (TransformationType<? extends Transformation> type : this.types) {
            if (!type.canParse.test(name)) continue;
            return true;
        }
        return false;
    }

    public boolean couldBeOnetimeTransformation(String name) {
        for (TransformationType<? extends Transformation> type : this.types) {
            if (!type.canParse.test(name) || !(type.parser.parse() instanceof OneTimeTransformation)) continue;
            return true;
        }
        return false;
    }

    static {
        EMPTY.clear();
    }
}

