/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.adventure.text.minimessage.transformation.inbuild;

import io.lumine.mythic.utils.adventure.text.Component;
import io.lumine.mythic.utils.adventure.text.TextComponent;
import io.lumine.mythic.utils.adventure.text.minimessage.parser.ParsingException;
import io.lumine.mythic.utils.adventure.text.minimessage.parser.Token;
import io.lumine.mythic.utils.adventure.text.minimessage.transformation.Transformation;
import io.lumine.mythic.utils.adventure.text.minimessage.transformation.TransformationParser;
import io.lumine.mythic.utils.text.examination.ExaminableProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class InsertionTransformation
extends Transformation {
    private String insertion;

    public static boolean canParse(String name) {
        return name.equalsIgnoreCase("insert");
    }

    private InsertionTransformation() {
    }

    @Override
    public void load(String name, List<Token> args) {
        super.load(name, args);
        if (!Token.oneString(args)) {
            throw new ParsingException("Doesn't know how to turn token with name '" + name + "' and arguments " + args + " into a insertion component", -1);
        }
        this.insertion = args.get(0).value();
    }

    @Override
    public Component apply(Component component, TextComponent.Builder parent) {
        return component.insertion(this.insertion);
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("insertion", this.insertion));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InsertionTransformation that = (InsertionTransformation)other;
        return Objects.equals(this.insertion, that.insertion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.insertion);
    }

    public static class Parser
    implements TransformationParser<InsertionTransformation> {
        @Override
        public InsertionTransformation parse() {
            return new InsertionTransformation();
        }
    }
}

