/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.cache;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class Expiring<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private final long durationNanos;
    private volatile T value;
    private volatile long expirationNanos;

    public static <T> Expiring<T> suppliedBy(Supplier<T> supplier, long duration, TimeUnit unit) {
        Objects.requireNonNull(supplier, "supplier");
        Preconditions.checkArgument(duration > 0L);
        Objects.requireNonNull(unit, "unit");
        return new Expiring<T>(supplier, duration, unit);
    }

    private Expiring(Supplier<T> supplier, long duration, TimeUnit unit) {
        this.supplier = supplier;
        this.durationNanos = unit.toNanos(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        long nanos = this.expirationNanos;
        long now = System.nanoTime();
        if (nanos == 0L || now - nanos >= 0L) {
            Expiring expiring = this;
            synchronized (expiring) {
                if (nanos == this.expirationNanos) {
                    T t2 = this.supplier.get();
                    this.value = t2;
                    nanos = now + this.durationNanos;
                    this.expirationNanos = nanos == 0L ? 1L : nanos;
                    return t2;
                }
            }
        }
        return this.value;
    }
}

