/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.cache;

import java.util.Objects;
import java.util.function.Supplier;

public final class Lazy<T>
implements Supplier<T> {
    private volatile Supplier<T> supplier;
    private volatile boolean initialized = false;
    private T value;

    public static <T> Lazy<T> suppliedBy(Supplier<T> supplier) {
        return new Lazy<Supplier<T>>(Objects.requireNonNull(supplier, "supplier"));
    }

    public static <T> Lazy<T> of(T value) {
        return new Lazy<T>(Objects.requireNonNull(value, "value"));
    }

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    private Lazy(T value) {
        this.value = value;
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.initialized) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (!this.initialized) {
                    T t2 = this.supplier.get();
                    this.value = t2;
                    this.initialized = true;
                    this.supplier = null;
                    return t2;
                }
            }
        }
        return this.value;
    }
}

