/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.caffeine.cache;

import io.lumine.mythic.utils.caffeine.cache.FW;
import io.lumine.mythic.utils.caffeine.cache.Node;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.ReferenceQueue;

class FWA<K, V>
extends FW<K, V> {
    protected static final VarHandle ACCESS_TIME;
    volatile long accessTime;
    Node<K, V> previousInAccessOrder;
    Node<K, V> nextInAccessOrder;

    FWA() {
    }

    FWA(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(key, keyReferenceQueue, value, valueReferenceQueue, weight, now);
        ACCESS_TIME.set(this, now);
    }

    FWA(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(keyReference, value, valueReferenceQueue, weight, now);
        ACCESS_TIME.set(this, now);
    }

    @Override
    public Node<K, V> getPreviousInVariableOrder() {
        return this.previousInAccessOrder;
    }

    @Override
    public void setPreviousInVariableOrder(Node<K, V> previousInAccessOrder) {
        this.previousInAccessOrder = previousInAccessOrder;
    }

    @Override
    public Node<K, V> getNextInVariableOrder() {
        return this.nextInAccessOrder;
    }

    @Override
    public void setNextInVariableOrder(Node<K, V> nextInAccessOrder) {
        this.nextInAccessOrder = nextInAccessOrder;
    }

    @Override
    public long getVariableTime() {
        return ACCESS_TIME.get(this);
    }

    @Override
    public void setVariableTime(long accessTime) {
        ACCESS_TIME.set(this, accessTime);
    }

    @Override
    public boolean casVariableTime(long expect, long update) {
        return this.accessTime == expect && ACCESS_TIME.compareAndSet(this, expect, update);
    }

    @Override
    public final long getAccessTime() {
        return ACCESS_TIME.get(this);
    }

    @Override
    public final void setAccessTime(long accessTime) {
        ACCESS_TIME.set(this, accessTime);
    }

    @Override
    public final Node<K, V> getPreviousInAccessOrder() {
        return this.previousInAccessOrder;
    }

    @Override
    public final void setPreviousInAccessOrder(Node<K, V> previousInAccessOrder) {
        this.previousInAccessOrder = previousInAccessOrder;
    }

    @Override
    public final Node<K, V> getNextInAccessOrder() {
        return this.nextInAccessOrder;
    }

    @Override
    public final void setNextInAccessOrder(Node<K, V> nextInAccessOrder) {
        this.nextInAccessOrder = nextInAccessOrder;
    }

    @Override
    public Node<K, V> newNode(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FWA<K, V>(key, keyReferenceQueue, value, valueReferenceQueue, weight, now);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FWA<K, V>(keyReference, value, valueReferenceQueue, weight, now);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            ACCESS_TIME = lookup.findVarHandle(FWA.class, "accessTime", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

