/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.caffeine.cache;

import io.lumine.mythic.utils.caffeine.cache.CacheLoader;
import io.lumine.mythic.utils.caffeine.cache.Caffeine;
import io.lumine.mythic.utils.caffeine.cache.MpscGrowableArrayQueue;
import io.lumine.mythic.utils.caffeine.cache.SI;
import io.lumine.mythic.utils.caffeine.cache.Ticker;

final class SIR<K, V>
extends SI<K, V> {
    final Ticker ticker;
    volatile long refreshAfterWriteNanos;
    final MpscGrowableArrayQueue<Runnable> writeBuffer;

    SIR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
        super(builder, cacheLoader, async);
        this.ticker = builder.getTicker();
        this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        this.writeBuffer = new MpscGrowableArrayQueue(4, WRITE_BUFFER_MAX);
    }

    @Override
    public Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected boolean refreshAfterWrite() {
        return true;
    }

    @Override
    protected long refreshAfterWriteNanos() {
        return this.refreshAfterWriteNanos;
    }

    @Override
    protected void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
        this.refreshAfterWriteNanos = refreshAfterWriteNanos;
    }

    @Override
    protected MpscGrowableArrayQueue<Runnable> writeBuffer() {
        return this.writeBuffer;
    }

    @Override
    protected boolean buffersWrites() {
        return true;
    }
}

