/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.collections;

import com.google.common.collect.Lists;
import io.lumine.mythic.utils.collections.AWeightedItem;
import io.lumine.mythic.utils.collections.ISelector;
import io.lumine.mythic.utils.collections.WeightedSelector;
import io.lumine.mythic.utils.functions.IParamFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WeightedCollection<T extends AWeightedItem> {
    private List<T> items = Lists.newArrayList();
    private double weight = 0.0;
    private ISelector<T> selector = new WeightedSelector();

    public WeightedCollection() {
    }

    public WeightedCollection(WeightedCollection<T> source) {
        this.items = source.getCopy();
        this.weight = source.weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getMaxWeight() {
        return this.items.isEmpty() ? 0.0 : ((AWeightedItem)this.items.get((int)0)).weight;
    }

    public double getMinWeight() {
        return this.items.isEmpty() ? 0.0 : ((AWeightedItem)this.items.get((int)this.items.size())).weight;
    }

    public int size() {
        return this.items.size();
    }

    public boolean add(T item) {
        return this.sortedAction(this.items::add, item);
    }

    public boolean addAll(Collection<? extends T> items) {
        return this.sortedAction(this.items::addAll, items);
    }

    public boolean remove(T item) {
        return this.sortedAction(this.items::remove, item);
    }

    public boolean removeAll(Collection<T> items) {
        return this.sortedAction(this.items::removeAll, items);
    }

    public void clear() {
        this.items.clear();
        this.weight = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T1, T2> T1 sortedAction(IParamFunction<T1, T2> action, T2 param) {
        try {
            T1 T1 = action.execute(param);
            return T1;
        }
        finally {
            this.items.sort(Collections.reverseOrder());
            this.weight = this.items.stream().mapToDouble(d -> d.weight).sum();
        }
    }

    public List<T> getView() {
        return Collections.unmodifiableList(this.items);
    }

    public List<T> getCopy() {
        return Lists.newArrayList(this.items);
    }

    public WeightedCollection<T> copy() {
        return new WeightedCollection<T>(this);
    }

    public T get() {
        return this.selector.get(this);
    }

    public T get(double offset) {
        return this.selector.get(this, offset);
    }

    public Collection<T> get(int count) {
        return this.selector.get(this, count);
    }

    public Collection<T> get(int count, double offset) {
        return this.selector.get(this, count, offset);
    }

    public Collection<T> getNonRepeating(int count) {
        return this.selector.getNonRepeating(this, count);
    }

    public Collection<T> getNonRepeating(int count, double offset) {
        return this.selector.getNonRepeating(this, count, offset);
    }
}

