/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.command.argument;

import io.lumine.mythic.utils.annotation.NonnullByDefault;
import io.lumine.mythic.utils.command.CommandInterruptException;
import io.lumine.mythic.utils.command.argument.Argument;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;

@NonnullByDefault
public interface ArgumentParser<T> {
    public static <T> ArgumentParser<T> of(Function<String, Optional<T>> parseFunction) {
        return parseFunction::apply;
    }

    public static <T> ArgumentParser<T> of(final Function<String, Optional<T>> parseFunction, final Function<String, CommandInterruptException> generateExceptionFunction) {
        return new ArgumentParser<T>(){

            @Override
            public Optional<T> parse(@Nonnull String t2) {
                return (Optional)parseFunction.apply(t2);
            }

            @Override
            public CommandInterruptException generateException(@Nonnull String s2) {
                return (CommandInterruptException)generateExceptionFunction.apply(s2);
            }
        };
    }

    public Optional<T> parse(@Nonnull String var1);

    default public CommandInterruptException generateException(@Nonnull String s2) {
        return new CommandInterruptException("&cUnable to parse argument: " + s2);
    }

    default public CommandInterruptException generateException(int missingArgumentIndex) {
        return new CommandInterruptException("&cArgument at index " + missingArgumentIndex + " is missing.");
    }

    @Nonnull
    default public T parseOrFail(@Nonnull String s2) throws CommandInterruptException {
        Optional<T> ret = this.parse(s2);
        if (!ret.isPresent()) {
            throw this.generateException(s2);
        }
        return ret.get();
    }

    @Nonnull
    default public Optional<T> parse(@Nonnull Argument argument) {
        return argument.value().flatMap(this::parse);
    }

    @Nonnull
    default public T parseOrFail(@Nonnull Argument argument) throws CommandInterruptException {
        Optional<String> value = argument.value();
        if (!value.isPresent()) {
            throw this.generateException(argument.index());
        }
        return this.parseOrFail(value.get());
    }

    @Nonnull
    default public ArgumentParser<T> thenTry(@Nonnull ArgumentParser<T> other) {
        ArgumentParser first = this;
        return t2 -> {
            Optional ret = first.parse(t2);
            return ret.isPresent() ? ret : other.parse(t2);
        };
    }
}

