/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.command.argument;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import io.lumine.mythic.utils.command.argument.ArgumentParser;
import io.lumine.mythic.utils.command.argument.ArgumentParserRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;

public class SimpleParserRegistry
implements ArgumentParserRegistry {
    private final Map<TypeToken<?>, List<ArgumentParser<?>>> parsers = new ConcurrentHashMap();

    @Override
    @Nonnull
    public <T> Optional<ArgumentParser<T>> find(@Nonnull TypeToken<T> type) {
        Objects.requireNonNull(type, "type");
        List<ArgumentParser<?>> parsers = this.parsers.get(type);
        if (parsers == null || parsers.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(parsers.get(0));
    }

    @Override
    @Nonnull
    public <T> Collection<ArgumentParser<T>> findAll(@Nonnull TypeToken<T> type) {
        Objects.requireNonNull(type, "type");
        List<ArgumentParser<?>> parsers = this.parsers.get(type);
        if (parsers == null || parsers.isEmpty()) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(parsers);
    }

    @Override
    public <T> void register(@Nonnull TypeToken<T> type, @Nonnull ArgumentParser<T> parser) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(parser, "parser");
        List list = this.parsers.computeIfAbsent(type, t2 -> new CopyOnWriteArrayList());
        if (!list.contains(parser)) {
            list.add(parser);
        }
    }
}

