/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.command.context;

import com.google.common.collect.ImmutableList;
import io.lumine.mythic.utils.command.argument.Argument;
import io.lumine.mythic.utils.command.argument.SimpleArgument;
import io.lumine.mythic.utils.command.context.CommandContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;

public class ImmutableCommandContext<T extends CommandSender>
implements CommandContext<T> {
    private final T sender;
    private final String label;
    private final ImmutableList<String> args;

    public ImmutableCommandContext(T sender, String label, String[] args) {
        this.sender = sender;
        this.label = label;
        this.args = ImmutableList.copyOf(args);
    }

    @Override
    @Nonnull
    public T sender() {
        return this.sender;
    }

    @Override
    @Nonnull
    public ImmutableList<String> args() {
        return this.args;
    }

    @Override
    @Nonnull
    public Argument arg(int index) {
        return new SimpleArgument(index, this.rawArg(index));
    }

    @Override
    @Nullable
    public String rawArg(int index) {
        if (index < 0 || index >= this.args.size()) {
            return null;
        }
        return (String)this.args.get(index);
    }

    @Override
    @Nonnull
    public String label() {
        return this.label;
    }
}

