/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.config.properties.types;

import io.lumine.mythic.utils.config.ConfigurationSection;
import io.lumine.mythic.utils.config.properties.PropertyType;
import io.lumine.mythic.utils.config.properties.types.BlockPositionProp;
import io.lumine.mythic.utils.plugin.LuminePlugin;
import io.lumine.mythic.utils.serialize.BlockPosition;
import io.lumine.mythic.utils.serialize.BlockRegion;

public class BlockRegionProp
extends PropertyType<BlockRegion> {
    private final BlockPositionProp min;
    private final BlockPositionProp max;

    public BlockRegionProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.min = new BlockPositionProp(plugin, file, node + ".Min");
        this.max = new BlockPositionProp(plugin, file, node + ".Max");
    }

    public BlockRegionProp(LuminePlugin plugin, Object file, String node, BlockRegion def) {
        super(plugin, file, node);
        this.min = new BlockPositionProp(plugin, file, node + ".Min", def.getMin());
        this.max = new BlockPositionProp(plugin, file, node + ".Max", def.getMax());
    }

    @Override
    protected BlockRegion compute(ConfigurationSection section, String node) {
        return BlockRegion.of((BlockPosition)this.min.get(section), (BlockPosition)this.max.get(section));
    }

    @Override
    public void set(String holder, BlockRegion value) {
        if (this.config == null) {
            return;
        }
        this.min.set(holder, value.getMin());
        this.max.set(holder, value.getMax());
    }
}

