/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.config.properties.types;

import io.lumine.mythic.utils.config.ConfigurationSection;
import io.lumine.mythic.utils.config.properties.PropertyType;
import io.lumine.mythic.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.utils.config.properties.types.LocProp;
import io.lumine.mythic.utils.plugin.LuminePlugin;
import io.lumine.mythic.utils.serialize.CircularZone;
import io.lumine.mythic.utils.serialize.Locus;

public class CircularZoneProp
extends PropertyType<CircularZone> {
    private final LocProp center;
    private final DoubleProp radius;

    public CircularZoneProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.center = new LocProp(plugin, file, node + ".Center");
        this.radius = new DoubleProp(plugin, file, node + ".Radius");
    }

    public CircularZoneProp(LuminePlugin plugin, Object file, String node, CircularZone def) {
        super(plugin, file, node);
        this.center = new LocProp(plugin, file, node + ".Center", def.getCenter());
        this.radius = new DoubleProp(plugin, file, node + ".Radius", def.getRadius());
    }

    @Override
    protected CircularZone compute(ConfigurationSection section, String node) {
        return CircularZone.of((Locus)this.center.get(section), (Double)this.radius.get(section));
    }

    @Override
    public void set(String holder, CircularZone value) {
        if (this.config == null) {
            return;
        }
        this.center.set(holder, value.getCenter());
        this.radius.set(holder, Double.valueOf(value.getRadius()));
    }
}

