/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.config.properties.types;

import io.lumine.mythic.utils.config.ConfigurationSection;
import io.lumine.mythic.utils.config.properties.PropertyType;
import io.lumine.mythic.utils.config.properties.types.BooleanProp;
import io.lumine.mythic.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.utils.config.properties.types.ItemProp;
import io.lumine.mythic.utils.config.properties.types.StringProp;
import io.lumine.mythic.utils.menu.IconBuilder;
import io.lumine.mythic.utils.plugin.LuminePlugin;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

public class IconProp<T>
extends PropertyType<IconBuilder<T>> {
    private IconBuilder<T> def;
    private ItemProp ITEM;
    private BooleanProp HIDE_FLAGS;
    private StringProp CLICK_COMMAND;
    private BooleanProp CLICK_COMMAND_AS_PLAYER;
    private BooleanProp CLICK_COMMAND_AS_OP;
    private StringProp CLICK_SOUND;
    private DoubleProp CLICK_VOLUME;
    private DoubleProp CLICK_PITCH;
    private BooleanProp CLICK_CLOSE;

    public IconProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.ITEM = new ItemProp(plugin, file, node);
        this.HIDE_FLAGS = new BooleanProp(plugin, file, node + ".HideFlags", true);
        this.CLICK_COMMAND = new StringProp(plugin, file, node + ".Click.Command", null);
        this.CLICK_COMMAND_AS_PLAYER = new BooleanProp(plugin, file, node + ".Click.CommandAsPlayer", false);
        this.CLICK_COMMAND_AS_OP = new BooleanProp(plugin, file, node + ".Click.CommandASOp", false);
        this.CLICK_SOUND = new StringProp(plugin, file, node + ".Click.Sound", null);
        this.CLICK_VOLUME = new DoubleProp(plugin, file, node + ".Click.Volume", 1.0);
        this.CLICK_PITCH = new DoubleProp(plugin, file, node + ".Click.Pitch", 1.0);
        this.CLICK_CLOSE = new BooleanProp(plugin, file, node + ".Click.ThenClose", false);
        this.def = IconBuilder.create().name("UNSET").material(Material.STONE);
    }

    public IconProp(LuminePlugin plugin, Object file, String node, IconBuilder<T> def) {
        super(plugin, file, node);
        this.def = def;
    }

    @Override
    protected IconBuilder<T> compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.def;
        }
        ItemStack itemIcon = (ItemStack)this.ITEM.get(section);
        boolean hideFlags = (Boolean)this.HIDE_FLAGS.get(section);
        String clickCommand = (String)this.CLICK_COMMAND.get(section);
        boolean clickAsPlayer = (Boolean)this.CLICK_COMMAND_AS_PLAYER.get(section);
        boolean clickAsOp = (Boolean)this.CLICK_COMMAND_AS_OP.get(section);
        String clickSound = (String)this.CLICK_SOUND.get(section);
        double clickVolume = (Double)this.CLICK_VOLUME.get(section);
        double clickPitch = (Double)this.CLICK_PITCH.get(section);
        boolean clickThenClose = (Boolean)this.CLICK_CLOSE.get(section);
        IconBuilder<Object> builder = IconBuilder.create();
        builder.icon(state -> itemIcon);
        if (hideFlags) {
            builder.hideFlags();
        }
        if (clickCommand != null) {
            builder.click((impl, player) -> {
                if (clickSound != null) {
                    player.playSound(player.getLocation(), clickSound, (float)clickVolume, (float)clickPitch);
                }
                String command = clickCommand;
                command = command.replace("<player.name>", player.getName());
                command = command.replace("<player.uuid>", player.getUniqueId().toString());
                if (clickAsPlayer) {
                    if (clickAsOp) {
                        boolean op = player.isOp();
                        player.setOp(true);
                        try {
                            player.performCommand(command);
                        }
                        finally {
                            player.setOp(op);
                        }
                    } else {
                        player.performCommand(command);
                    }
                } else {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                }
                if (clickThenClose) {
                    player.closeInventory();
                }
            });
        }
        return builder;
    }

    @Override
    public void set(String holder, IconBuilder<T> value) {
        if (this.config == null) {
            return;
        }
    }
}

