/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.config.properties.types;

import io.lumine.mythic.utils.config.ConfigurationSection;
import io.lumine.mythic.utils.config.properties.PropertyHolder;
import io.lumine.mythic.utils.config.properties.PropertyType;
import io.lumine.mythic.utils.config.properties.types.LangProp;
import io.lumine.mythic.utils.plugin.LuminePlugin;
import io.lumine.mythic.utils.text.Text;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;

public class LangListProp
extends PropertyType<List<String>> {
    public LangListProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
    }

    public List<String> get(Map<String, Object> replacements) {
        List list = (List)super.get();
        ListIterator<String> it = list.listIterator();
        while (it.hasNext()) {
            it.set(LangProp.replaceTokens((String)it.next(), replacements));
        }
        return list;
    }

    public List<String> get(PropertyHolder holder, Map<String, Object> replacements) {
        return this.get(holder.getPropertyNode(), replacements);
    }

    public List<String> get(String holder, Map<String, Object> replacements) {
        List list = (List)super.get(holder);
        ListIterator<String> it = list.listIterator();
        while (it.hasNext()) {
            it.set(LangProp.replaceTokens((String)it.next(), replacements));
        }
        return list;
    }

    @Override
    protected List<String> compute(ConfigurationSection section, String node) {
        return section.getStringList(node).stream().map(line -> Text.colorizeLegacy(Text.colorize(line))).collect(Collectors.toList());
    }
}

