/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.config.properties.types;

import io.lumine.mythic.utils.config.ConfigurationSection;
import io.lumine.mythic.utils.config.file.FileConfiguration;
import io.lumine.mythic.utils.config.properties.PropertyType;
import io.lumine.mythic.utils.plugin.LuminePlugin;
import io.lumine.mythic.utils.serialize.Locus;

public class LocProp
extends PropertyType<Locus> {
    private final Locus def;

    public LocProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.def = Locus.of(0.0, 0.0, 0.0);
    }

    public LocProp(LuminePlugin plugin, Object file, String node, Locus def) {
        super(plugin, file, node);
        this.def = def;
    }

    @Override
    protected Locus compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.def;
        }
        String prop = section.getString(node);
        if (prop == null) {
            return this.def;
        }
        try {
            String[] split = prop.split(",");
            double x = Double.valueOf(split[0]);
            double y = Double.valueOf(split[1]);
            double z = Double.valueOf(split[2]);
            return Locus.of(x, y, z);
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void set(String holder, Locus value) {
        if (this.config == null) {
            return;
        }
        String val = value.getX() + "," + value.getY() + "," + value.getZ();
        if (holder != null) {
            this.config.set(holder + "." + this.node, val);
        } else {
            this.config.set(this.node, val);
        }
        try {
            ((FileConfiguration)this.config).save(this.plugin.getPropertyFile(this.file));
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }
}

