/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.config.properties.types;

import io.lumine.mythic.utils.config.ConfigurationSection;
import io.lumine.mythic.utils.config.properties.PropertyType;
import io.lumine.mythic.utils.plugin.LuminePlugin;
import io.lumine.mythic.utils.serialize.Direction;
import io.lumine.mythic.utils.serialize.Locus;
import io.lumine.mythic.utils.serialize.Orient;
import java.util.ArrayList;
import java.util.List;

public class OrientListProp
extends PropertyType<List<Orient>> {
    public OrientListProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
    }

    @Override
    protected List<Orient> compute(ConfigurationSection section, String node) {
        ArrayList<Orient> result = new ArrayList<Orient>();
        if (section == null) {
            return result;
        }
        List<String> listprop = section.getStringList(node);
        if (listprop == null) {
            return result;
        }
        for (String prop : listprop) {
            try {
                String[] split = prop.split(",");
                double x = Double.valueOf(split[0]);
                double y = Double.valueOf(split[1]);
                double z = Double.valueOf(split[2]);
                float yaw = Float.valueOf(split[3]).floatValue();
                float pitch = Float.valueOf(split[4]).floatValue();
                result.add(Orient.of(Locus.of(x, y, z), Direction.of(yaw, pitch)));
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public void set(String holder, List<Orient> value) {
        if (this.config == null) {
            return;
        }
        ArrayList<String> out = new ArrayList<String>();
        for (Orient orient : value) {
            String o = orient.getLocus().getX() + "," + orient.getLocus().getY() + "," + orient.getLocus().getZ() + "," + orient.getDirection().getYaw() + "," + orient.getDirection().getPitch();
            out.add(o);
        }
        this.config.set(this.node, out);
    }
}

