/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.config.properties.types;

import io.lumine.mythic.utils.config.ConfigurationSection;
import io.lumine.mythic.utils.config.properties.PropertyType;
import io.lumine.mythic.utils.config.properties.types.PositionProp;
import io.lumine.mythic.utils.plugin.LuminePlugin;
import io.lumine.mythic.utils.serialize.Position;
import io.lumine.mythic.utils.serialize.Region;

public class RegionProp
extends PropertyType<Region> {
    private final PositionProp min;
    private final PositionProp max;

    public RegionProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.min = new PositionProp(plugin, file, node + ".Min");
        this.max = new PositionProp(plugin, file, node + ".Max");
    }

    public RegionProp(LuminePlugin plugin, Object file, String node, Region def) {
        super(plugin, file, node);
        this.min = new PositionProp(plugin, file, node + ".Min", def.getMin());
        this.max = new PositionProp(plugin, file, node + ".Max", def.getMax());
    }

    @Override
    protected Region compute(ConfigurationSection section, String node) {
        return Region.of((Position)this.min.get(section), (Position)this.max.get(section));
    }

    @Override
    public void set(String holder, Region value) {
        if (this.config == null) {
            return;
        }
        this.min.set(holder, value.getMin());
        this.max.set(holder, value.getMax());
    }
}

