/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.events.extra;

import io.lumine.mythic.utils.events.extra.ArmorEquipEvent;
import io.lumine.mythic.utils.events.extra.ArmorType;
import io.lumine.mythic.utils.plugin.LoaderUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ArmorEquipEventListener
implements Listener {
    private final List<String> blockedMaterials = this.getBlocks();

    public ArmorEquipEventListener() {
        LoaderUtils.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)LoaderUtils.getPlugin());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void inventoryClick(InventoryClickEvent e) {
        boolean shift = false;
        boolean numberkey = false;
        if (e.isCancelled()) {
            return;
        }
        if (e.getAction() == InventoryAction.NOTHING) {
            return;
        }
        if (e.getClick().equals((Object)ClickType.SHIFT_LEFT) || e.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
            shift = true;
        }
        if (e.getClick().equals((Object)ClickType.NUMBER_KEY)) {
            numberkey = true;
        }
        if (e.getSlotType() != InventoryType.SlotType.ARMOR && e.getSlotType() != InventoryType.SlotType.QUICKBAR && e.getSlotType() != InventoryType.SlotType.CONTAINER) {
            return;
        }
        if (e.getClickedInventory() != null && !e.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        if (!e.getInventory().getType().equals((Object)InventoryType.CRAFTING) && !e.getInventory().getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        ArmorType newArmorType = ArmorType.matchType(shift ? e.getCurrentItem() : e.getCursor());
        if (!shift && newArmorType != null && e.getRawSlot() != newArmorType.getSlot()) {
            return;
        }
        if (shift) {
            newArmorType = ArmorType.matchType(e.getCurrentItem());
            if (newArmorType != null) {
                boolean equipping = true;
                if (e.getRawSlot() == newArmorType.getSlot()) {
                    equipping = false;
                }
                if (newArmorType.equals((Object)ArmorType.HELMET) && (!equipping ? !ArmorEquipEventListener.isAirOrNull(e.getWhoClicked().getInventory().getHelmet()) : ArmorEquipEventListener.isAirOrNull(e.getWhoClicked().getInventory().getHelmet())) || newArmorType.equals((Object)ArmorType.CHESTPLATE) && (!equipping ? !ArmorEquipEventListener.isAirOrNull(e.getWhoClicked().getInventory().getChestplate()) : ArmorEquipEventListener.isAirOrNull(e.getWhoClicked().getInventory().getChestplate())) || newArmorType.equals((Object)ArmorType.LEGGINGS) && (!equipping ? !ArmorEquipEventListener.isAirOrNull(e.getWhoClicked().getInventory().getLeggings()) : ArmorEquipEventListener.isAirOrNull(e.getWhoClicked().getInventory().getLeggings())) || newArmorType.equals((Object)ArmorType.BOOTS) && (equipping ? ArmorEquipEventListener.isAirOrNull(e.getWhoClicked().getInventory().getBoots()) : !ArmorEquipEventListener.isAirOrNull(e.getWhoClicked().getInventory().getBoots()))) {
                    ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)e.getWhoClicked(), ArmorEquipEvent.EquipMethod.SHIFT_CLICK, newArmorType, equipping ? null : e.getCurrentItem(), equipping ? e.getCurrentItem() : null);
                    Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                    if (armorEquipEvent.isCancelled()) {
                        e.setCancelled(true);
                    }
                }
            }
        } else {
            ItemStack newArmorPiece = e.getCursor();
            ItemStack oldArmorPiece = e.getCurrentItem();
            if (numberkey) {
                if (e.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
                    ItemStack hotbarItem = e.getClickedInventory().getItem(e.getHotbarButton());
                    if (!ArmorEquipEventListener.isAirOrNull(hotbarItem)) {
                        newArmorType = ArmorType.matchType(hotbarItem);
                        newArmorPiece = hotbarItem;
                        oldArmorPiece = e.getClickedInventory().getItem(e.getSlot());
                    } else {
                        newArmorType = ArmorType.matchType(!ArmorEquipEventListener.isAirOrNull(e.getCurrentItem()) ? e.getCurrentItem() : e.getCursor());
                    }
                }
            } else if (ArmorEquipEventListener.isAirOrNull(e.getCursor()) && !ArmorEquipEventListener.isAirOrNull(e.getCurrentItem())) {
                newArmorType = ArmorType.matchType(e.getCurrentItem());
            }
            if (newArmorType != null && e.getRawSlot() == newArmorType.getSlot()) {
                ArmorEquipEvent.EquipMethod method = ArmorEquipEvent.EquipMethod.PICK_DROP;
                if (e.getAction().equals((Object)InventoryAction.HOTBAR_SWAP) || numberkey) {
                    method = ArmorEquipEvent.EquipMethod.HOTBAR_SWAP;
                }
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)e.getWhoClicked(), method, newArmorType, oldArmorPiece, newArmorPiece);
                Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerInteractEvent(PlayerInteractEvent e) {
        if (e.useItemInHand().equals((Object)Event.Result.DENY)) {
            return;
        }
        if (e.getAction() == Action.PHYSICAL) {
            return;
        }
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ArmorType newArmorType;
            Player player = e.getPlayer();
            if (!e.useInteractedBlock().equals((Object)Event.Result.DENY) && e.getClickedBlock() != null && e.getAction() == Action.RIGHT_CLICK_BLOCK && !player.isSneaking()) {
                Material mat = e.getClickedBlock().getType();
                for (String s2 : this.blockedMaterials) {
                    if (!mat.name().equalsIgnoreCase(s2)) continue;
                    return;
                }
            }
            if ((newArmorType = ArmorType.matchType(e.getItem())) != null && (newArmorType.equals((Object)ArmorType.HELMET) && ArmorEquipEventListener.isAirOrNull(e.getPlayer().getInventory().getHelmet()) || newArmorType.equals((Object)ArmorType.CHESTPLATE) && ArmorEquipEventListener.isAirOrNull(e.getPlayer().getInventory().getChestplate()) || newArmorType.equals((Object)ArmorType.LEGGINGS) && ArmorEquipEventListener.isAirOrNull(e.getPlayer().getInventory().getLeggings()) || newArmorType.equals((Object)ArmorType.BOOTS) && ArmorEquipEventListener.isAirOrNull(e.getPlayer().getInventory().getBoots()))) {
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(e.getPlayer(), ArmorEquipEvent.EquipMethod.HOTBAR, ArmorType.matchType(e.getItem()), null, e.getItem());
                Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    e.setCancelled(true);
                    player.updateInventory();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void inventoryDrag(InventoryDragEvent event) {
        ArmorType type = ArmorType.matchType(event.getOldCursor());
        if (event.getRawSlots().isEmpty()) {
            return;
        }
        if (type != null && type.getSlot() == event.getRawSlots().stream().findFirst().orElse(0).intValue()) {
            ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)event.getWhoClicked(), ArmorEquipEvent.EquipMethod.DRAG, type, null, event.getOldCursor());
            Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
            if (armorEquipEvent.isCancelled()) {
                event.setResult(Event.Result.DENY);
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void itemBreakEvent(PlayerItemBreakEvent e) {
        ArmorType type = ArmorType.matchType(e.getBrokenItem());
        if (type != null) {
            Player p = e.getPlayer();
            ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(p, ArmorEquipEvent.EquipMethod.BROKE, type, e.getBrokenItem(), null);
            Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
            if (armorEquipEvent.isCancelled()) {
                ItemStack i = e.getBrokenItem().clone();
                i.setAmount(1);
                i.setDurability((short)(i.getDurability() - 1));
                if (type.equals((Object)ArmorType.HELMET)) {
                    p.getInventory().setHelmet(i);
                } else if (type.equals((Object)ArmorType.CHESTPLATE)) {
                    p.getInventory().setChestplate(i);
                } else if (type.equals((Object)ArmorType.LEGGINGS)) {
                    p.getInventory().setLeggings(i);
                } else if (type.equals((Object)ArmorType.BOOTS)) {
                    p.getInventory().setBoots(i);
                }
            }
        }
    }

    @EventHandler
    public void playerDeathEvent(PlayerDeathEvent e) {
        Player p = e.getEntity();
        if (e.getKeepInventory()) {
            return;
        }
        for (ItemStack i : p.getInventory().getArmorContents()) {
            if (ArmorEquipEventListener.isAirOrNull(i)) continue;
            Bukkit.getServer().getPluginManager().callEvent((Event)new ArmorEquipEvent(p, ArmorEquipEvent.EquipMethod.DEATH, ArmorType.matchType(i), i, null));
        }
    }

    @EventHandler
    public void dispenseArmorEvent(BlockDispenseArmorEvent event) {
        ArmorType type = ArmorType.matchType(event.getItem());
        if (type != null && event.getTargetEntity() instanceof Player) {
            Player p = (Player)event.getTargetEntity();
            ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(p, ArmorEquipEvent.EquipMethod.DISPENSER, type, null, event.getItem());
            Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
            if (armorEquipEvent.isCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    public static boolean isAirOrNull(ItemStack item) {
        return item == null || item.getType().equals((Object)Material.AIR);
    }

    private List<String> getBlocks() {
        ArrayList<String> blocks = new ArrayList<String>();
        blocks.add("DAYLIGHT_DETECTOR");
        blocks.add("DAYLIGHT_DETECTOR_INVERTED");
        blocks.add("FURNACE");
        blocks.add("CHEST");
        blocks.add("TRAPPED_CHEST");
        blocks.add("BEACON");
        blocks.add("DISPENSER");
        blocks.add("DROPPER");
        blocks.add("HOPPER");
        blocks.add("WORKBENCH");
        blocks.add("ENCHANTMENT_TABLE");
        blocks.add("ENDER_CHEST");
        blocks.add("ANVIL");
        blocks.add("BED_BLOCK");
        blocks.add("FENCE_GATE");
        blocks.add("SPRUCE_FENCE_GATE");
        blocks.add("BIRCH_FENCE_GATE");
        blocks.add("ACACIA_FENCE_GATE");
        blocks.add("JUNGLE_FENCE_GATE");
        blocks.add("DARK_OAK_FENCE_GATE");
        blocks.add("IRON_DOOR_BLOCK");
        blocks.add("WOODEN_DOOR");
        blocks.add("SPRUCE_DOOR");
        blocks.add("BIRCH_DOOR");
        blocks.add("JUNGLE_DOOR");
        blocks.add("ACACIA_DOOR");
        blocks.add("DARK_OAK_DOOR");
        blocks.add("WOOD_BUTTON");
        blocks.add("STONE_BUTTON");
        blocks.add("TRAP_DOOR");
        blocks.add("IRON_TRAPDOOR");
        blocks.add("DIODE_BLOCK_OFF");
        blocks.add("DIODE_BLOCK_ON");
        blocks.add("REDSTONE_COMPARATOR_OFF");
        blocks.add("REDSTONE_COMPARATOR_ON");
        blocks.add("FENCE");
        blocks.add("SPRUCE_FENCE");
        blocks.add("BIRCH_FENCE");
        blocks.add("JUNGLE_FENCE");
        blocks.add("DARK_OAK_FENCE");
        blocks.add("ACACIA_FENCE");
        blocks.add("NETHER_FENCE");
        blocks.add("BREWING_STAND");
        blocks.add("CAULDRON");
        blocks.add("SIGN_POST");
        blocks.add("WALL_SIGN");
        blocks.add("SIGN");
        blocks.add("DRAGON_EGG");
        blocks.add("LEVER");
        blocks.add("SHULKER_BOX");
        return blocks;
    }
}

