/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.events.functional.merged;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import io.lumine.mythic.utils.events.MergedSubscription;
import io.lumine.mythic.utils.events.functional.merged.MergedHandlerMapping;
import io.lumine.mythic.utils.events.functional.merged.MergedSubscriptionBuilderImpl;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;

class MergedEventListener<T>
implements MergedSubscription<T>,
EventExecutor,
Listener {
    private final TypeToken<T> handledClass;
    private final Map<Class<? extends Event>, MergedHandlerMapping<T, ? extends Event>> mappings;
    private final BiConsumer<? super Event, Throwable> exceptionConsumer;
    private final Predicate<T>[] filters;
    private final BiPredicate<MergedSubscription<T>, T>[] preExpiryTests;
    private final BiPredicate<MergedSubscription<T>, T>[] midExpiryTests;
    private final BiPredicate<MergedSubscription<T>, T>[] postExpiryTests;
    private final BiConsumer<MergedSubscription<T>, ? super T>[] handlers;
    private final AtomicLong callCount = new AtomicLong(0L);
    private final AtomicBoolean active = new AtomicBoolean(true);

    MergedEventListener(MergedSubscriptionBuilderImpl<T> builder, List<BiConsumer<MergedSubscription<T>, ? super T>> handlers) {
        this.handledClass = builder.handledClass;
        this.mappings = ImmutableMap.copyOf(builder.mappings);
        this.exceptionConsumer = builder.exceptionConsumer;
        this.filters = builder.filters.toArray(new Predicate[builder.filters.size()]);
        this.preExpiryTests = builder.preExpiryTests.toArray(new BiPredicate[builder.preExpiryTests.size()]);
        this.midExpiryTests = builder.midExpiryTests.toArray(new BiPredicate[builder.midExpiryTests.size()]);
        this.postExpiryTests = builder.postExpiryTests.toArray(new BiPredicate[builder.postExpiryTests.size()]);
        this.handlers = handlers.toArray(new BiConsumer[handlers.size()]);
    }

    void register(Plugin plugin) {
        IdentityHashMap<Class<Event>, EventPriority> registered = new IdentityHashMap<Class<Event>, EventPriority>();
        for (Map.Entry<Class<Event>, MergedHandlerMapping<T, Event>> ent : this.mappings.entrySet()) {
            Class<? extends Event> type = ent.getKey();
            Class<Event> registrationType = MergedEventListener.getRegistrationClass(type);
            EventPriority existing = registered.put(registrationType, ent.getValue().getPriority());
            if (existing != null) {
                if (existing == ent.getValue().getPriority()) continue;
                throw new RuntimeException("Unable to register the same event with different priorities: " + type + " --> " + registrationType);
            }
            Bukkit.getPluginManager().registerEvent(registrationType, (Listener)this, ent.getValue().getPriority(), (EventExecutor)this, plugin, false);
        }
    }

    public void execute(Listener listener, Event event) {
        MergedHandlerMapping<T, Event> mapping = this.mappings.get(event.getClass());
        if (mapping == null) {
            return;
        }
        Function<Object, Object> function = mapping.getFunction();
        if (!this.active.get()) {
            event.getHandlers().unregister(listener);
            return;
        }
        T handledInstance = function.apply(event);
        for (BiPredicate<MergedSubscription<MergedEventListener>, MergedEventListener> biPredicate : this.preExpiryTests) {
            if (!biPredicate.test(this, (MergedEventListener)handledInstance)) continue;
            event.getHandlers().unregister(listener);
            this.active.set(false);
            return;
        }
        try {
            for (Predicate<T> predicate : this.filters) {
                if (predicate.test(handledInstance)) continue;
                return;
            }
            for (BiPredicate<MergedSubscription<T>, T> biPredicate : this.midExpiryTests) {
                if (!biPredicate.test(this, handledInstance)) continue;
                event.getHandlers().unregister(listener);
                this.active.set(false);
                return;
            }
            for (BiConsumer<MergedSubscription<T>, ? super T> biConsumer : this.handlers) {
                biConsumer.accept(this, (T)handledInstance);
            }
            this.callCount.incrementAndGet();
        }
        catch (Throwable t2) {
            this.exceptionConsumer.accept((Event)event, t2);
        }
        for (BiPredicate<MergedSubscription<T>, T> biPredicate : this.postExpiryTests) {
            if (!biPredicate.test(this, handledInstance)) continue;
            event.getHandlers().unregister(listener);
            this.active.set(false);
            return;
        }
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public boolean isClosed() {
        return !this.active.get();
    }

    @Override
    public long getCallCounter() {
        return this.callCount.get();
    }

    @Override
    public boolean unregister() {
        if (!this.active.getAndSet(false)) {
            return false;
        }
        for (Class<? extends Event> clazz : this.mappings.keySet()) {
            MergedEventListener.unregisterListener(clazz, this);
        }
        return true;
    }

    @Override
    @Nonnull
    public Class<? super T> getHandledClass() {
        return this.handledClass.getRawType();
    }

    @Override
    @Nonnull
    public Set<Class<? extends Event>> getEventClasses() {
        return this.mappings.keySet();
    }

    private static void unregisterListener(Class<? extends Event> eventClass, Listener listener) {
        try {
            Method getHandlerListMethod = eventClass.getMethod("getHandlerList", new Class[0]);
            HandlerList handlerList = (HandlerList)getHandlerListMethod.invoke(null, new Object[0]);
            handlerList.unregister(listener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Class<? extends Event> getRegistrationClass(Class<? extends Event> clazz) {
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException var2) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return MergedEventListener.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ".");
        }
    }
}

