/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.events.functional.single;

import io.lumine.mythic.utils.events.SingleSubscription;
import io.lumine.mythic.utils.events.functional.single.EventListener;
import io.lumine.mythic.utils.events.functional.single.SingleHandlerList;
import io.lumine.mythic.utils.events.functional.single.SingleSubscriptionBuilderImpl;
import io.lumine.mythic.utils.plugin.LoaderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

class SingleHandlerListImpl<T extends Event>
implements SingleHandlerList<T> {
    private final SingleSubscriptionBuilderImpl<T> builder;
    private final List<BiConsumer<SingleSubscription<T>, ? super T>> handlers = new ArrayList<BiConsumer<SingleSubscription<T>, ? super T>>(1);

    SingleHandlerListImpl(@Nonnull SingleSubscriptionBuilderImpl<T> builder) {
        this.builder = builder;
    }

    @Override
    @Nonnull
    public SingleHandlerList<T> biConsumer(@Nonnull BiConsumer<SingleSubscription<T>, ? super T> handler) {
        Objects.requireNonNull(handler, "handler");
        this.handlers.add(handler);
        return this;
    }

    @Override
    @Nonnull
    public SingleSubscription<T> register() {
        if (this.handlers.isEmpty()) {
            throw new IllegalStateException("No handlers have been registered");
        }
        EventListener<T> listener = new EventListener<T>(this.builder, this.handlers);
        listener.register((Plugin)LoaderUtils.getPlugin());
        return listener;
    }
}

