/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.files;

import io.lumine.mythic.utils.config.ConfigurationLoader;
import io.lumine.mythic.utils.plugin.LuminePlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Files {
    public static File BACKUP_FOLDER = null;

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    Files.delete(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }

    public static List<File> getAll(String directoryName) {
        File[] fList;
        File directory = new File(directoryName);
        ArrayList<File> resultList = new ArrayList<File>();
        for (File file : fList = directory.listFiles()) {
            if (file.isFile() && (file.getName().endsWith(".yml") || file.getName().endsWith(".txt"))) {
                resultList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            resultList.addAll(Files.getAll(file.getAbsolutePath()));
        }
        return resultList;
    }

    public static String toList(String s2, File[] list) {
        for (File f : list) {
            s2 = s2 + f.getName() + ", ";
        }
        return s2;
    }

    public static List<File> getAllYaml(String directoryName) {
        File[] fList;
        File directory = new File(directoryName);
        ArrayList<File> resultList = new ArrayList<File>();
        for (File file : fList = directory.listFiles()) {
            if (file.isFile() && file.getName().endsWith(".yml")) {
                resultList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            resultList.addAll(Files.getAll(file.getAbsolutePath()));
        }
        return resultList;
    }

    public static <T extends LuminePlugin> List<ConfigurationLoader<T>> getConfigurationLoaders(T plugin, List<File> files, String folder) {
        ArrayList<ConfigurationLoader<T>> list = new ArrayList<ConfigurationLoader<T>>();
        for (File file : files) {
            list.add(new ConfigurationLoader<T>(plugin, file, folder));
        }
        return list;
    }
}

