/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.gson.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

class OptionalAdapter<T>
extends TypeAdapter<Optional<T>> {
    private final TypeAdapter<T> delegate;

    public OptionalAdapter(TypeAdapter<T> delegate) {
        this.delegate = delegate;
    }

    public void write(JsonWriter out, Optional<T> value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        if (!value.isPresent()) {
            out.nullValue();
            return;
        }
        this.delegate.write(out, value.get());
    }

    public Optional<T> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return Optional.empty();
        }
        return Optional.of(this.delegate.read(in));
    }

    public static OptionalAdapter getInstance(Gson gson, TypeToken typeToken) {
        TypeAdapter delegate;
        Type type = typeToken.getType();
        if (type instanceof ParameterizedType) {
            Type innerType = ((ParameterizedType)type).getActualTypeArguments()[0];
            delegate = gson.getAdapter(TypeToken.get((Type)innerType));
        } else if (type instanceof Class) {
            delegate = gson.getAdapter(Object.class);
        } else {
            throw new JsonIOException("Unexpected type type:" + type.getClass());
        }
        return new OptionalAdapter(delegate);
    }
}

