/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.impl;

import io.lumine.mythic.utils.lib.http.HttpClientConnection;
import io.lumine.mythic.utils.lib.http.HttpConnectionMetrics;
import io.lumine.mythic.utils.lib.http.HttpEntity;
import io.lumine.mythic.utils.lib.http.HttpEntityEnclosingRequest;
import io.lumine.mythic.utils.lib.http.HttpException;
import io.lumine.mythic.utils.lib.http.HttpRequest;
import io.lumine.mythic.utils.lib.http.HttpResponse;
import io.lumine.mythic.utils.lib.http.HttpResponseFactory;
import io.lumine.mythic.utils.lib.http.annotation.NotThreadSafe;
import io.lumine.mythic.utils.lib.http.impl.DefaultHttpResponseFactory;
import io.lumine.mythic.utils.lib.http.impl.HttpConnectionMetricsImpl;
import io.lumine.mythic.utils.lib.http.impl.entity.EntityDeserializer;
import io.lumine.mythic.utils.lib.http.impl.entity.EntitySerializer;
import io.lumine.mythic.utils.lib.http.impl.entity.LaxContentLengthStrategy;
import io.lumine.mythic.utils.lib.http.impl.entity.StrictContentLengthStrategy;
import io.lumine.mythic.utils.lib.http.impl.io.DefaultHttpResponseParser;
import io.lumine.mythic.utils.lib.http.impl.io.HttpRequestWriter;
import io.lumine.mythic.utils.lib.http.io.EofSensor;
import io.lumine.mythic.utils.lib.http.io.HttpMessageParser;
import io.lumine.mythic.utils.lib.http.io.HttpMessageWriter;
import io.lumine.mythic.utils.lib.http.io.HttpTransportMetrics;
import io.lumine.mythic.utils.lib.http.io.SessionInputBuffer;
import io.lumine.mythic.utils.lib.http.io.SessionOutputBuffer;
import io.lumine.mythic.utils.lib.http.params.HttpParams;
import io.lumine.mythic.utils.lib.http.util.Args;
import java.io.IOException;
import java.net.SocketTimeoutException;

@Deprecated
@NotThreadSafe
public abstract class AbstractHttpClientConnection
implements HttpClientConnection {
    private final EntitySerializer entityserializer = this.createEntitySerializer();
    private final EntityDeserializer entitydeserializer = this.createEntityDeserializer();
    private SessionInputBuffer inbuffer = null;
    private SessionOutputBuffer outbuffer = null;
    private EofSensor eofSensor = null;
    private HttpMessageParser<HttpResponse> responseParser = null;
    private HttpMessageWriter<HttpRequest> requestWriter = null;
    private HttpConnectionMetricsImpl metrics = null;

    protected abstract void assertOpen() throws IllegalStateException;

    protected EntityDeserializer createEntityDeserializer() {
        return new EntityDeserializer(new LaxContentLengthStrategy());
    }

    protected EntitySerializer createEntitySerializer() {
        return new EntitySerializer(new StrictContentLengthStrategy());
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return DefaultHttpResponseFactory.INSTANCE;
    }

    protected HttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        return new DefaultHttpResponseParser(buffer, null, responseFactory, params);
    }

    protected HttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new HttpRequestWriter(buffer, null, params);
    }

    protected HttpConnectionMetricsImpl createConnectionMetrics(HttpTransportMetrics inTransportMetric, HttpTransportMetrics outTransportMetric) {
        return new HttpConnectionMetricsImpl(inTransportMetric, outTransportMetric);
    }

    protected void init(SessionInputBuffer inbuffer, SessionOutputBuffer outbuffer, HttpParams params) {
        this.inbuffer = Args.notNull(inbuffer, "Input session buffer");
        this.outbuffer = Args.notNull(outbuffer, "Output session buffer");
        if (inbuffer instanceof EofSensor) {
            this.eofSensor = (EofSensor)((Object)inbuffer);
        }
        this.responseParser = this.createResponseParser(inbuffer, this.createHttpResponseFactory(), params);
        this.requestWriter = this.createRequestWriter(outbuffer, params);
        this.metrics = this.createConnectionMetrics(inbuffer.getMetrics(), outbuffer.getMetrics());
    }

    @Override
    public boolean isResponseAvailable(int timeout) throws IOException {
        this.assertOpen();
        try {
            return this.inbuffer.isDataAvailable(timeout);
        }
        catch (SocketTimeoutException ex) {
            return false;
        }
    }

    @Override
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        this.assertOpen();
        this.requestWriter.write(request);
        this.metrics.incrementRequestCount();
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        this.assertOpen();
        if (request.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.outbuffer, request, request.getEntity());
    }

    protected void doFlush() throws IOException {
        this.outbuffer.flush();
    }

    @Override
    public void flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        this.assertOpen();
        HttpResponse response = this.responseParser.parse();
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.metrics.incrementResponseCount();
        }
        return response;
    }

    @Override
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        this.assertOpen();
        HttpEntity entity = this.entitydeserializer.deserialize(this.inbuffer, response);
        response.setEntity(entity);
    }

    protected boolean isEof() {
        return this.eofSensor != null && this.eofSensor.isEof();
    }

    @Override
    public boolean isStale() {
        if (!this.isOpen()) {
            return true;
        }
        if (this.isEof()) {
            return true;
        }
        try {
            this.inbuffer.isDataAvailable(1);
            return this.isEof();
        }
        catch (SocketTimeoutException ex) {
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.metrics;
    }
}

