/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.impl;

import io.lumine.mythic.utils.lib.http.HttpClientConnection;
import io.lumine.mythic.utils.lib.http.HttpEntity;
import io.lumine.mythic.utils.lib.http.HttpEntityEnclosingRequest;
import io.lumine.mythic.utils.lib.http.HttpException;
import io.lumine.mythic.utils.lib.http.HttpRequest;
import io.lumine.mythic.utils.lib.http.HttpResponse;
import io.lumine.mythic.utils.lib.http.annotation.NotThreadSafe;
import io.lumine.mythic.utils.lib.http.config.MessageConstraints;
import io.lumine.mythic.utils.lib.http.entity.ContentLengthStrategy;
import io.lumine.mythic.utils.lib.http.impl.BHttpConnectionBase;
import io.lumine.mythic.utils.lib.http.impl.io.DefaultHttpRequestWriterFactory;
import io.lumine.mythic.utils.lib.http.impl.io.DefaultHttpResponseParserFactory;
import io.lumine.mythic.utils.lib.http.io.HttpMessageParser;
import io.lumine.mythic.utils.lib.http.io.HttpMessageParserFactory;
import io.lumine.mythic.utils.lib.http.io.HttpMessageWriter;
import io.lumine.mythic.utils.lib.http.io.HttpMessageWriterFactory;
import io.lumine.mythic.utils.lib.http.util.Args;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

@NotThreadSafe
public class DefaultBHttpClientConnection
extends BHttpConnectionBase
implements HttpClientConnection {
    private final HttpMessageParser<HttpResponse> responseParser;
    private final HttpMessageWriter<HttpRequest> requestWriter;

    public DefaultBHttpClientConnection(int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super(buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy);
        this.requestWriter = (requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE).create(this.getSessionOutputBuffer());
        this.responseParser = (responseParserFactory != null ? responseParserFactory : DefaultHttpResponseParserFactory.INSTANCE).create(this.getSessionInputBuffer(), constraints);
    }

    public DefaultBHttpClientConnection(int buffersize, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints) {
        this(buffersize, buffersize, chardecoder, charencoder, constraints, null, null, null, null);
    }

    public DefaultBHttpClientConnection(int buffersize) {
        this(buffersize, buffersize, null, null, null, null, null, null, null);
    }

    protected void onResponseReceived(HttpResponse response) {
    }

    protected void onRequestSubmitted(HttpRequest request) {
    }

    @Override
    public void bind(Socket socket) throws IOException {
        super.bind(socket);
    }

    @Override
    public boolean isResponseAvailable(int timeout) throws IOException {
        this.ensureOpen();
        try {
            return this.awaitInput(timeout);
        }
        catch (SocketTimeoutException ex) {
            return false;
        }
    }

    @Override
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        this.ensureOpen();
        this.requestWriter.write(request);
        this.onRequestSubmitted(request);
        this.incrementRequestCount();
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        this.ensureOpen();
        HttpEntity entity = request.getEntity();
        if (entity == null) {
            return;
        }
        OutputStream outstream = this.prepareOutput(request);
        entity.writeTo(outstream);
        outstream.close();
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        this.ensureOpen();
        HttpResponse response = this.responseParser.parse();
        this.onResponseReceived(response);
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.incrementResponseCount();
        }
        return response;
    }

    @Override
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        this.ensureOpen();
        HttpEntity entity = this.prepareInput(response);
        response.setEntity(entity);
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.doFlush();
    }
}

