/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.impl.auth;

import io.lumine.mythic.utils.lib.http.FormattedHeader;
import io.lumine.mythic.utils.lib.http.Header;
import io.lumine.mythic.utils.lib.http.HttpRequest;
import io.lumine.mythic.utils.lib.http.annotation.NotThreadSafe;
import io.lumine.mythic.utils.lib.http.auth.AuthenticationException;
import io.lumine.mythic.utils.lib.http.auth.ChallengeState;
import io.lumine.mythic.utils.lib.http.auth.ContextAwareAuthScheme;
import io.lumine.mythic.utils.lib.http.auth.Credentials;
import io.lumine.mythic.utils.lib.http.auth.MalformedChallengeException;
import io.lumine.mythic.utils.lib.http.protocol.HTTP;
import io.lumine.mythic.utils.lib.http.protocol.HttpContext;
import io.lumine.mythic.utils.lib.http.util.Args;
import io.lumine.mythic.utils.lib.http.util.CharArrayBuffer;
import java.util.Locale;

@NotThreadSafe
public abstract class AuthSchemeBase
implements ContextAwareAuthScheme {
    protected ChallengeState challengeState;

    @Deprecated
    public AuthSchemeBase(ChallengeState challengeState) {
        this.challengeState = challengeState;
    }

    public AuthSchemeBase() {
    }

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        int pos;
        CharArrayBuffer buffer;
        Args.notNull(header, "Header");
        String authheader = header.getName();
        if (authheader.equalsIgnoreCase("WWW-Authenticate")) {
            this.challengeState = ChallengeState.TARGET;
        } else if (authheader.equalsIgnoreCase("Proxy-Authenticate")) {
            this.challengeState = ChallengeState.PROXY;
        } else {
            throw new MalformedChallengeException("Unexpected header name: " + authheader);
        }
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            pos = ((FormattedHeader)header).getValuePos();
        } else {
            String s2 = header.getValue();
            if (s2 == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            buffer = new CharArrayBuffer(s2.length());
            buffer.append(s2);
            pos = 0;
        }
        while (pos < buffer.length() && HTTP.isWhitespace(buffer.charAt(pos))) {
            ++pos;
        }
        int beginIndex = pos;
        while (pos < buffer.length() && !HTTP.isWhitespace(buffer.charAt(pos))) {
            ++pos;
        }
        int endIndex = pos;
        String s3 = buffer.substring(beginIndex, endIndex);
        if (!s3.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid scheme identifier: " + s3);
        }
        this.parseChallenge(buffer, pos, buffer.length());
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return this.authenticate(credentials, request);
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3) throws MalformedChallengeException;

    public boolean isProxy() {
        return this.challengeState != null && this.challengeState == ChallengeState.PROXY;
    }

    public ChallengeState getChallengeState() {
        return this.challengeState;
    }

    public String toString() {
        String name = this.getSchemeName();
        if (name != null) {
            return name.toUpperCase(Locale.ROOT);
        }
        return super.toString();
    }
}

