/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.impl.auth;

import io.lumine.mythic.utils.lib.http.Header;
import io.lumine.mythic.utils.lib.http.HttpRequest;
import io.lumine.mythic.utils.lib.http.annotation.NotThreadSafe;
import io.lumine.mythic.utils.lib.http.auth.AuthenticationException;
import io.lumine.mythic.utils.lib.http.auth.Credentials;
import io.lumine.mythic.utils.lib.http.impl.auth.GGSSchemeBase;
import io.lumine.mythic.utils.lib.http.protocol.HttpContext;
import io.lumine.mythic.utils.lib.http.util.Args;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

@NotThreadSafe
public class KerberosScheme
extends GGSSchemeBase {
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";

    public KerberosScheme(boolean stripPort, boolean useCanonicalHostname) {
        super(stripPort, useCanonicalHostname);
    }

    public KerberosScheme(boolean stripPort) {
        super(stripPort);
    }

    public KerberosScheme() {
    }

    @Override
    public String getSchemeName() {
        return "Kerberos";
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return super.authenticate(credentials, request, context);
    }

    @Override
    protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
        return super.generateToken(input, authServer);
    }

    @Override
    protected byte[] generateToken(byte[] input, String authServer, Credentials credentials) throws GSSException {
        return this.generateGSSToken(input, new Oid(KERBEROS_OID), authServer, credentials);
    }

    @Override
    public String getParameter(String name) {
        Args.notNull(name, "Parameter name");
        return null;
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }
}

