/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.impl.client;

import io.lumine.mythic.utils.lib.http.annotation.GuardedBy;
import io.lumine.mythic.utils.lib.http.annotation.ThreadSafe;
import io.lumine.mythic.utils.lib.http.client.CookieStore;
import io.lumine.mythic.utils.lib.http.cookie.Cookie;
import io.lumine.mythic.utils.lib.http.cookie.CookieIdentityComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

@ThreadSafe
public class BasicCookieStore
implements CookieStore,
Serializable {
    private static final long serialVersionUID = -7581093305228232025L;
    @GuardedBy(value="this")
    private final TreeSet<Cookie> cookies = new TreeSet<Cookie>(new CookieIdentityComparator());

    @Override
    public synchronized void addCookie(Cookie cookie) {
        if (cookie != null) {
            this.cookies.remove(cookie);
            if (!cookie.isExpired(new Date())) {
                this.cookies.add(cookie);
            }
        }
    }

    public synchronized void addCookies(Cookie[] cookies) {
        if (cookies != null) {
            for (Cookie cooky : cookies) {
                this.addCookie(cooky);
            }
        }
    }

    @Override
    public synchronized List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies);
    }

    @Override
    public synchronized boolean clearExpired(Date date) {
        if (date == null) {
            return false;
        }
        boolean removed = false;
        Iterator<Cookie> it = this.cookies.iterator();
        while (it.hasNext()) {
            if (!it.next().isExpired(date)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public synchronized void clear() {
        this.cookies.clear();
    }

    public synchronized String toString() {
        return this.cookies.toString();
    }
}

