/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.impl.client;

import io.lumine.mythic.utils.lib.http.HttpConnection;
import io.lumine.mythic.utils.lib.http.annotation.Immutable;
import io.lumine.mythic.utils.lib.http.auth.AuthScheme;
import io.lumine.mythic.utils.lib.http.auth.AuthState;
import io.lumine.mythic.utils.lib.http.auth.Credentials;
import io.lumine.mythic.utils.lib.http.client.UserTokenHandler;
import io.lumine.mythic.utils.lib.http.client.protocol.HttpClientContext;
import io.lumine.mythic.utils.lib.http.conn.ManagedHttpClientConnection;
import io.lumine.mythic.utils.lib.http.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public static final DefaultUserTokenHandler INSTANCE = new DefaultUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpConnection conn;
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Principal userPrincipal = null;
        AuthState targetAuthState = clientContext.getTargetAuthState();
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = clientContext.getProxyAuthState();
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = clientContext.getConnection()).isOpen() && conn instanceof ManagedHttpClientConnection && (sslsession = ((ManagedHttpClientConnection)conn).getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

