/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.impl.client;

import io.lumine.mythic.utils.lib.http.ConnectionReuseStrategy;
import io.lumine.mythic.utils.lib.http.HttpEntity;
import io.lumine.mythic.utils.lib.http.HttpException;
import io.lumine.mythic.utils.lib.http.HttpHost;
import io.lumine.mythic.utils.lib.http.HttpResponse;
import io.lumine.mythic.utils.lib.http.HttpVersion;
import io.lumine.mythic.utils.lib.http.auth.AuthSchemeRegistry;
import io.lumine.mythic.utils.lib.http.auth.AuthScope;
import io.lumine.mythic.utils.lib.http.auth.AuthState;
import io.lumine.mythic.utils.lib.http.auth.Credentials;
import io.lumine.mythic.utils.lib.http.client.config.RequestConfig;
import io.lumine.mythic.utils.lib.http.client.params.HttpClientParamConfig;
import io.lumine.mythic.utils.lib.http.client.protocol.RequestClientConnControl;
import io.lumine.mythic.utils.lib.http.config.ConnectionConfig;
import io.lumine.mythic.utils.lib.http.conn.HttpConnectionFactory;
import io.lumine.mythic.utils.lib.http.conn.ManagedHttpClientConnection;
import io.lumine.mythic.utils.lib.http.conn.routing.HttpRoute;
import io.lumine.mythic.utils.lib.http.conn.routing.RouteInfo;
import io.lumine.mythic.utils.lib.http.entity.BufferedHttpEntity;
import io.lumine.mythic.utils.lib.http.impl.DefaultConnectionReuseStrategy;
import io.lumine.mythic.utils.lib.http.impl.auth.BasicSchemeFactory;
import io.lumine.mythic.utils.lib.http.impl.auth.DigestSchemeFactory;
import io.lumine.mythic.utils.lib.http.impl.auth.HttpAuthenticator;
import io.lumine.mythic.utils.lib.http.impl.auth.KerberosSchemeFactory;
import io.lumine.mythic.utils.lib.http.impl.auth.NTLMSchemeFactory;
import io.lumine.mythic.utils.lib.http.impl.auth.SPNegoSchemeFactory;
import io.lumine.mythic.utils.lib.http.impl.client.BasicCredentialsProvider;
import io.lumine.mythic.utils.lib.http.impl.client.ProxyAuthenticationStrategy;
import io.lumine.mythic.utils.lib.http.impl.conn.ManagedHttpClientConnectionFactory;
import io.lumine.mythic.utils.lib.http.impl.execchain.TunnelRefusedException;
import io.lumine.mythic.utils.lib.http.message.BasicHttpRequest;
import io.lumine.mythic.utils.lib.http.params.BasicHttpParams;
import io.lumine.mythic.utils.lib.http.params.HttpParamConfig;
import io.lumine.mythic.utils.lib.http.params.HttpParams;
import io.lumine.mythic.utils.lib.http.protocol.BasicHttpContext;
import io.lumine.mythic.utils.lib.http.protocol.HttpProcessor;
import io.lumine.mythic.utils.lib.http.protocol.HttpRequestExecutor;
import io.lumine.mythic.utils.lib.http.protocol.ImmutableHttpProcessor;
import io.lumine.mythic.utils.lib.http.protocol.RequestTargetHost;
import io.lumine.mythic.utils.lib.http.protocol.RequestUserAgent;
import io.lumine.mythic.utils.lib.http.util.Args;
import io.lumine.mythic.utils.lib.http.util.EntityUtils;
import java.io.IOException;
import java.net.Socket;

public class ProxyClient {
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
    private final ConnectionConfig connectionConfig;
    private final RequestConfig requestConfig;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final ProxyAuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthState proxyAuthState;
    private final AuthSchemeRegistry authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;

    public ProxyClient(HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, ConnectionConfig connectionConfig, RequestConfig requestConfig) {
        this.connFactory = connFactory != null ? connFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.connectionConfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
        this.requestConfig = requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
        this.httpProcessor = new ImmutableHttpProcessor(new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent());
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new ProxyAuthenticationStrategy();
        this.authenticator = new HttpAuthenticator();
        this.proxyAuthState = new AuthState();
        this.authSchemeRegistry = new AuthSchemeRegistry();
        this.authSchemeRegistry.register("Basic", new BasicSchemeFactory());
        this.authSchemeRegistry.register("Digest", new DigestSchemeFactory());
        this.authSchemeRegistry.register("NTLM", new NTLMSchemeFactory());
        this.authSchemeRegistry.register("Negotiate", new SPNegoSchemeFactory());
        this.authSchemeRegistry.register("Kerberos", new KerberosSchemeFactory());
        this.reuseStrategy = new DefaultConnectionReuseStrategy();
    }

    @Deprecated
    public ProxyClient(HttpParams params) {
        this(null, HttpParamConfig.getConnectionConfig(params), HttpClientParamConfig.getRequestConfig(params));
    }

    public ProxyClient(RequestConfig requestConfig) {
        this(null, null, requestConfig);
    }

    public ProxyClient() {
        this(null, null, null);
    }

    @Deprecated
    public HttpParams getParams() {
        return new BasicHttpParams();
    }

    @Deprecated
    public AuthSchemeRegistry getAuthSchemeRegistry() {
        return this.authSchemeRegistry;
    }

    public Socket tunnel(HttpHost proxy, HttpHost target, Credentials credentials) throws IOException, HttpException {
        HttpEntity entity;
        int status;
        HttpResponse response;
        Args.notNull(proxy, "Proxy host");
        Args.notNull(target, "Target host");
        Args.notNull(credentials, "Credentials");
        HttpHost host = target;
        if (host.getPort() <= 0) {
            host = new HttpHost(host.getHostName(), 80, host.getSchemeName());
        }
        HttpRoute route = new HttpRoute(host, this.requestConfig.getLocalAddress(), proxy, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        ManagedHttpClientConnection conn = this.connFactory.create(route, this.connectionConfig);
        BasicHttpContext context = new BasicHttpContext();
        BasicHttpRequest connect = new BasicHttpRequest("CONNECT", host.toHostString(), HttpVersion.HTTP_1_1);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(proxy), credentials);
        context.setAttribute("http.target_host", target);
        context.setAttribute("http.connection", conn);
        context.setAttribute("http.request", connect);
        context.setAttribute("http.route", route);
        context.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
        context.setAttribute("http.auth.credentials-provider", credsProvider);
        context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        context.setAttribute("http.request-config", this.requestConfig);
        this.requestExec.preProcess(connect, this.httpProcessor, context);
        while (true) {
            if (!conn.isOpen()) {
                Socket socket = new Socket(proxy.getHostName(), proxy.getPort());
                conn.bind(socket);
            }
            this.authenticator.generateAuthResponse(connect, this.proxyAuthState, context);
            response = this.requestExec.execute(connect, conn, context);
            status = response.getStatusLine().getStatusCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
            }
            if (!this.authenticator.isAuthenticationRequested(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context) || !this.authenticator.handleAuthChallenge(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context)) break;
            if (this.reuseStrategy.keepAlive(response, context)) {
                entity = response.getEntity();
                EntityUtils.consume(entity);
            } else {
                conn.close();
            }
            connect.removeHeaders("Proxy-Authorization");
        }
        status = response.getStatusLine().getStatusCode();
        if (status > 299) {
            entity = response.getEntity();
            if (entity != null) {
                response.setEntity(new BufferedHttpEntity(entity));
            }
            conn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
        }
        return conn.getSocket();
    }
}

