/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.impl.cookie;

import io.lumine.mythic.utils.lib.http.annotation.Immutable;
import io.lumine.mythic.utils.lib.http.cookie.CommonCookieAttributeHandler;
import io.lumine.mythic.utils.lib.http.cookie.Cookie;
import io.lumine.mythic.utils.lib.http.cookie.CookieOrigin;
import io.lumine.mythic.utils.lib.http.cookie.CookieRestrictionViolationException;
import io.lumine.mythic.utils.lib.http.cookie.MalformedCookieException;
import io.lumine.mythic.utils.lib.http.cookie.SetCookie;
import io.lumine.mythic.utils.lib.http.impl.cookie.AbstractCookieAttributeHandler;
import io.lumine.mythic.utils.lib.http.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

