/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.impl.cookie;

import io.lumine.mythic.utils.lib.http.annotation.Immutable;
import io.lumine.mythic.utils.lib.http.cookie.ClientCookie;
import io.lumine.mythic.utils.lib.http.cookie.CommonCookieAttributeHandler;
import io.lumine.mythic.utils.lib.http.cookie.Cookie;
import io.lumine.mythic.utils.lib.http.cookie.CookieOrigin;
import io.lumine.mythic.utils.lib.http.cookie.CookieRestrictionViolationException;
import io.lumine.mythic.utils.lib.http.cookie.MalformedCookieException;
import io.lumine.mythic.utils.lib.http.cookie.SetCookie;
import io.lumine.mythic.utils.lib.http.cookie.SetCookie2;
import io.lumine.mythic.utils.lib.http.util.Args;

@Immutable
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

