/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.impl.pool;

import io.lumine.mythic.utils.lib.http.HttpClientConnection;
import io.lumine.mythic.utils.lib.http.HttpHost;
import io.lumine.mythic.utils.lib.http.annotation.ThreadSafe;
import io.lumine.mythic.utils.lib.http.config.ConnectionConfig;
import io.lumine.mythic.utils.lib.http.config.SocketConfig;
import io.lumine.mythic.utils.lib.http.impl.pool.BasicConnFactory;
import io.lumine.mythic.utils.lib.http.impl.pool.BasicPoolEntry;
import io.lumine.mythic.utils.lib.http.params.HttpParams;
import io.lumine.mythic.utils.lib.http.pool.AbstractConnPool;
import io.lumine.mythic.utils.lib.http.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

