/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.protocol;

import io.lumine.mythic.utils.lib.http.HttpException;
import io.lumine.mythic.utils.lib.http.HttpRequest;
import io.lumine.mythic.utils.lib.http.HttpRequestInterceptor;
import io.lumine.mythic.utils.lib.http.annotation.Immutable;
import io.lumine.mythic.utils.lib.http.params.HttpParams;
import io.lumine.mythic.utils.lib.http.protocol.HttpContext;
import io.lumine.mythic.utils.lib.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s2 = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s2 = (String)params.getParameter("http.useragent");
            }
            if (s2 == null) {
                s2 = this.userAgent;
            }
            if (s2 != null) {
                request.addHeader("User-Agent", s2);
            }
        }
    }
}

