/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.lib.http.protocol;

import io.lumine.mythic.utils.lib.http.Header;
import io.lumine.mythic.utils.lib.http.HttpEntity;
import io.lumine.mythic.utils.lib.http.HttpException;
import io.lumine.mythic.utils.lib.http.HttpRequest;
import io.lumine.mythic.utils.lib.http.HttpResponse;
import io.lumine.mythic.utils.lib.http.HttpResponseInterceptor;
import io.lumine.mythic.utils.lib.http.HttpVersion;
import io.lumine.mythic.utils.lib.http.ProtocolVersion;
import io.lumine.mythic.utils.lib.http.annotation.Immutable;
import io.lumine.mythic.utils.lib.http.protocol.HttpContext;
import io.lumine.mythic.utils.lib.http.protocol.HttpCoreContext;
import io.lumine.mythic.utils.lib.http.util.Args;
import java.io.IOException;

@Immutable
public class ResponseConnControl
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRequest request;
        Args.notNull(response, "HTTP response");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        int status = response.getStatusLine().getStatusCode();
        if (status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 503 || status == 501) {
            response.setHeader("Connection", "Close");
            return;
        }
        Header explicit = response.getFirstHeader("Connection");
        if (explicit != null && "Close".equalsIgnoreCase(explicit.getValue())) {
            return;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
            if (entity.getContentLength() < 0L && (!entity.isChunked() || ver.lessEquals(HttpVersion.HTTP_1_0))) {
                response.setHeader("Connection", "Close");
                return;
            }
        }
        if ((request = corecontext.getRequest()) != null) {
            Header header = request.getFirstHeader("Connection");
            if (header != null) {
                response.setHeader("Connection", header.getValue());
            } else if (request.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                response.setHeader("Connection", "Close");
            }
        }
    }
}

