/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.menu;

import io.lumine.mythic.utils.menu.EditableIcon;
import io.lumine.mythic.utils.menu.Menu;
import io.lumine.mythic.utils.menu.MenuBuilder;
import io.lumine.mythic.utils.menu.MenuHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;

public class EditableMenuBuilder<T> {
    private final MenuBuilder<T> builder;
    private final Map<String, EditableIcon<T>> icons;
    private final List<Integer> dataIcons;
    private final List<Integer> freeIcons;

    public Optional<EditableIcon<T>> getIcon(String key) {
        return Optional.ofNullable(this.icons.getOrDefault(key, null));
    }

    public void defaultClick(BiFunction<MenuHelper.OpenMenu<T>, Integer, Boolean> freeSlotFunc) {
        this.builder.defaultClick(freeSlotFunc);
    }

    public Menu<T> build() {
        this.icons.values().forEach(eIcon -> eIcon.getSlots().forEach(slot -> this.builder.addIcon((int)slot, eIcon.getBuilder().build())));
        this.builder.dataSlots(this.dataIcons);
        this.builder.unprotectedSlots(this.freeIcons);
        return this.builder.build();
    }

    public EditableMenuBuilder(MenuBuilder<T> builder, Map<String, EditableIcon<T>> icons, List<Integer> dataIcons, List<Integer> freeIcons) {
        this.builder = builder;
        this.icons = icons;
        this.dataIcons = dataIcons;
        this.freeIcons = freeIcons;
    }

    public MenuBuilder<T> getBuilder() {
        return this.builder;
    }

    public Map<String, EditableIcon<T>> getIcons() {
        return this.icons;
    }

    public List<Integer> getDataIcons() {
        return this.dataIcons;
    }

    public List<Integer> getFreeIcons() {
        return this.freeIcons;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditableMenuBuilder)) {
            return false;
        }
        EditableMenuBuilder other = (EditableMenuBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MenuBuilder<T> this$builder = this.getBuilder();
        MenuBuilder<T> other$builder = other.getBuilder();
        if (this$builder == null ? other$builder != null : !this$builder.equals(other$builder)) {
            return false;
        }
        Map<String, EditableIcon<T>> this$icons = this.getIcons();
        Map<String, EditableIcon<T>> other$icons = other.getIcons();
        if (this$icons == null ? other$icons != null : !((Object)this$icons).equals(other$icons)) {
            return false;
        }
        List<Integer> this$dataIcons = this.getDataIcons();
        List<Integer> other$dataIcons = other.getDataIcons();
        if (this$dataIcons == null ? other$dataIcons != null : !((Object)this$dataIcons).equals(other$dataIcons)) {
            return false;
        }
        List<Integer> this$freeIcons = this.getFreeIcons();
        List<Integer> other$freeIcons = other.getFreeIcons();
        return !(this$freeIcons == null ? other$freeIcons != null : !((Object)this$freeIcons).equals(other$freeIcons));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EditableMenuBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MenuBuilder<T> $builder = this.getBuilder();
        result = result * 59 + ($builder == null ? 43 : $builder.hashCode());
        Map<String, EditableIcon<T>> $icons = this.getIcons();
        result = result * 59 + ($icons == null ? 43 : ((Object)$icons).hashCode());
        List<Integer> $dataIcons = this.getDataIcons();
        result = result * 59 + ($dataIcons == null ? 43 : ((Object)$dataIcons).hashCode());
        List<Integer> $freeIcons = this.getFreeIcons();
        result = result * 59 + ($freeIcons == null ? 43 : ((Object)$freeIcons).hashCode());
        return result;
    }

    public String toString() {
        return "EditableMenuBuilder(builder=" + this.getBuilder() + ", icons=" + this.getIcons() + ", dataIcons=" + this.getDataIcons() + ", freeIcons=" + this.getFreeIcons() + ")";
    }
}

