/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.menu;

import io.lumine.mythic.utils.menu.Icon;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class IconBuilder<T> {
    private Function<T, Material> materialFunc;
    private Function<T, String> nameFunc;
    private Function<T, List<String>> loreFunc;
    private Function<T, Integer> modelFunc;
    private Function<T, Integer> amountFunc;
    private Function<T, ItemStack> iconFunc;
    private Function<T, ItemStack> blinkFunc;
    private BiConsumer<T, Player> clickFunc;
    private BiConsumer<T, Player> rightClickFunc;
    private ItemStack itemStack;
    private boolean hideFlags = false;

    public static <T> IconBuilder<T> create() {
        return new IconBuilder<T>();
    }

    private IconBuilder() {
    }

    public IconBuilder<T> item(ItemStack itemStack) {
        this.itemStack = itemStack;
        return this;
    }

    public IconBuilder<T> icon(Material material) {
        this.materialFunc = _state -> material;
        return this;
    }

    public IconBuilder<T> icon(Function<T, ItemStack> materialFunc) {
        this.iconFunc = materialFunc;
        return this;
    }

    public IconBuilder<T> blink(Function<T, ItemStack> materialFunc) {
        this.blinkFunc = materialFunc;
        return this;
    }

    public IconBuilder<T> material(Material material) {
        this.materialFunc = _state -> material;
        return this;
    }

    public IconBuilder<T> material(Function<T, Material> materialFunc) {
        this.materialFunc = materialFunc;
        return this;
    }

    public IconBuilder<T> name(String name) {
        this.nameFunc = _impl -> name;
        return this;
    }

    public IconBuilder<T> name(Function<T, String> nameFunc) {
        this.nameFunc = nameFunc;
        return this;
    }

    public IconBuilder<T> lore(List<String> lore) {
        this.loreFunc = _impl -> lore;
        return this;
    }

    public IconBuilder<T> lore(Function<T, List<String>> loreFunc) {
        this.loreFunc = loreFunc;
        return this;
    }

    public IconBuilder<T> click(BiConsumer<T, Player> clickFunc) {
        this.clickFunc = clickFunc;
        return this;
    }

    public IconBuilder<T> rightClick(BiConsumer<T, Player> clickFunc) {
        this.rightClickFunc = clickFunc;
        return this;
    }

    @Deprecated
    public IconBuilder<T> data(Byte data) {
        return this;
    }

    @Deprecated
    public IconBuilder<T> data(Function<T, Byte> dataFunc) {
        return this;
    }

    public IconBuilder<T> model(int data) {
        this.modelFunc = _state -> data;
        return this;
    }

    public IconBuilder<T> model(Function<T, Integer> dataFunc) {
        this.modelFunc = dataFunc;
        return this;
    }

    public IconBuilder<T> amount(int data) {
        this.amountFunc = _state -> data;
        return this;
    }

    public IconBuilder<T> amount(Function<T, Integer> amountFunc) {
        this.amountFunc = amountFunc;
        return this;
    }

    public IconBuilder<T> hideFlags() {
        this.hideFlags = true;
        return this;
    }

    public Icon<T> build() {
        if (this.iconFunc != null) {
            return new Icon<T>(this.nameFunc, this.loreFunc, this.clickFunc, this.rightClickFunc, this.modelFunc, this.amountFunc, this.iconFunc, this.blinkFunc, this.hideFlags);
        }
        if (this.itemStack != null) {
            return new Icon<T>(this.itemStack.clone(), this.nameFunc, this.loreFunc, this.clickFunc, this.rightClickFunc, this.modelFunc, this.amountFunc, this.blinkFunc, this.hideFlags);
        }
        if (this.materialFunc == null) {
            throw new IllegalStateException("Material must be specified!");
        }
        return new Icon<T>(this.materialFunc, this.nameFunc, this.loreFunc, this.clickFunc, this.rightClickFunc, this.modelFunc, this.amountFunc, this.blinkFunc, this.hideFlags);
    }
}

