/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.menu;

import io.lumine.mythic.utils.config.properties.types.MenuProp;
import io.lumine.mythic.utils.logging.Log;
import io.lumine.mythic.utils.menu.EditableMenuBuilder;
import io.lumine.mythic.utils.menu.Menu;
import java.util.List;
import org.bukkit.entity.Player;

public abstract class ReloadableMenu<T> {
    private final MenuProp<T> menuProperty;
    private EditableMenuBuilder<T> builder;
    private Menu<T> menu;
    private boolean buildOnOpen;

    public ReloadableMenu(MenuProp<T> menu) {
        this(menu, false);
    }

    public ReloadableMenu(MenuProp<T> menu, boolean buildOnOpen) {
        this.menuProperty = menu;
        this.buildOnOpen = buildOnOpen;
    }

    public void reload() {
        this.builder = (EditableMenuBuilder)this.menuProperty.get();
        if (this.builder == null) {
            Log.error("MenuProp returned null in ReloadableMenu");
            Thread.dumpStack();
            return;
        }
        EditableMenuBuilder<T> build = this.build(this.builder);
        if (build == null) {
            Log.error("ReloadableMenu builder returned null");
            Thread.dumpStack();
            return;
        }
        this.menu = build.build();
    }

    public abstract EditableMenuBuilder<T> build(EditableMenuBuilder<T> var1);

    public void open(Player player, T state) {
        if (this.buildOnOpen) {
            this.build(this.builder).build().open(player, state);
        } else {
            this.menu.open(player, state);
        }
    }

    public void open(Player player, T state, List<?> data) {
        Log.info("Data Points: {0}", data.size());
        if (this.buildOnOpen) {
            this.build(this.builder).build().open(player, state, data);
        } else {
            this.menu.open(player, state, data);
        }
    }

    public void nextPage(Player player) {
        this.menu.nextPage(player);
    }

    public void previousPage(Player player) {
        this.menu.previousPage(player);
    }
}

