/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.menu.hotbar;

import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.menu.Icon;
import io.lumine.mythic.utils.menu.MenuHelper;
import io.lumine.mythic.utils.menu.MonitoredState;
import io.lumine.mythic.utils.menu.hotbar.ActiveHotbarMenu;
import io.lumine.mythic.utils.menu.hotbar.HotbarMenu;
import io.lumine.mythic.utils.plugin.LoaderUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class HotbarMenuHelper
implements Listener {
    private static HotbarMenuHelper _instance = new HotbarMenuHelper();
    private final Map<UUID, ActiveHotbarMenu<?>> openMenus = new HashMap();

    protected static <T> ActiveHotbarMenu<T> registerOpen(Player player, HotbarMenu<T> menu, T state) {
        ActiveHotbarMenu<T> amenu = new ActiveHotbarMenu<T>(player.getUniqueId(), menu, state);
        HotbarMenuHelper._instance.openMenus.put(player.getUniqueId(), amenu);
        return amenu;
    }

    protected static void registerClosed(UUID player) {
        HotbarMenuHelper._instance.openMenus.remove(player);
    }

    private HotbarMenuHelper() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)LoaderUtils.getPlugin());
        Bukkit.getScheduler().runTaskTimer((Plugin)LoaderUtils.getPlugin(), this::updateMenus, 10L, 10L);
    }

    @EventHandler
    private void onClose(PlayerQuitEvent event) {
        this.openMenus.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.PHYSICAL) {
            return;
        }
        ActiveHotbarMenu<?> openMenu = this.openMenus.get(event.getPlayer().getUniqueId());
        if (openMenu == null) {
            return;
        }
        if (MenuHelper.get_instance().getOpenMenus().containsKey(event.getPlayer().getUniqueId())) {
            return;
        }
        int slot = event.getPlayer().getInventory().getHeldItemSlot();
        Player player = event.getPlayer();
        this.handleClick(openMenu, player, slot);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ActiveHotbarMenu<?> openMenu = this.openMenus.get(event.getWhoClicked().getUniqueId());
        if (openMenu == null) {
            return;
        }
        if (event.getSlotType() != InventoryType.SlotType.QUICKBAR) {
            event.setCancelled(true);
        } else if (event.getSlotType() == InventoryType.SlotType.ARMOR && event.getCurrentItem().getType() == Material.PLAYER_HEAD) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(PlayerInteractEntityEvent event) {
        ActiveHotbarMenu<?> openMenu = this.openMenus.get(event.getPlayer().getUniqueId());
        if (openMenu == null) {
            return;
        }
        if (event.getRightClicked() instanceof ArmorStand || event.getRightClicked() instanceof ItemFrame) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryClick(BlockPlaceEvent event) {
        ActiveHotbarMenu<?> openMenu = this.openMenus.get(event.getPlayer().getUniqueId());
        if (openMenu == null) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        ActiveHotbarMenu<?> openMenu = this.openMenus.get(event.getPlayer().getUniqueId());
        if (openMenu == null) {
            return;
        }
        Player player = event.getPlayer();
        int slot = player.getInventory().getHeldItemSlot();
        if (openMenu.getMenu().getIcons().containsKey(slot)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawn(PlayerDeathEvent event) {
        ActiveHotbarMenu<?> openMenu = this.openMenus.get(event.getEntity().getUniqueId());
        if (openMenu == null) {
            return;
        }
        openMenu.terminate();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChangeMode(PlayerGameModeChangeEvent event) {
        ActiveHotbarMenu<?> openMenu = this.openMenus.get(event.getPlayer().getUniqueId());
        if (openMenu == null) {
            return;
        }
        this.updateMenu(event.getPlayer().getUniqueId(), openMenu);
    }

    private <T> void handleClick(ActiveHotbarMenu<T> openMenu, Player player, int slot) {
        openMenu.getMenu().getIcon(slot).ifPresent(icon -> icon.getClickFunc().ifPresent(func -> func.accept(openMenu.getState(), player)));
    }

    private <T> void handleRightClick(ActiveHotbarMenu<T> openMenu, Player player, int slot) {
        openMenu.getMenu().getIcon(slot).ifPresent(icon -> icon.getRightClickFunc().ifPresent(func -> func.accept(openMenu.getState(), player)));
    }

    @EventHandler
    private void onDrag(InventoryDragEvent event) {
        if (this.openMenus.containsKey(event.getWhoClicked().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    private void updateMenus() {
        this.openMenus.forEach((uuid, menu) -> this.updateMenu((UUID)uuid, (ActiveHotbarMenu)menu));
    }

    private <T> void updateMenu(UUID uuid, ActiveHotbarMenu<T> openMenu) {
        PlayerInventory inv;
        Player player;
        try {
            player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                Schedulers.sync().runLater(() -> this.openMenus.remove(uuid), 1L);
                return;
            }
            inv = Bukkit.getPlayer((UUID)uuid).getInventory();
        }
        catch (Exception ex) {
            Player player2 = Bukkit.getPlayer((UUID)uuid);
            if (player2 == null) {
                Schedulers.sync().runLater(() -> this.openMenus.remove(uuid), 1L);
            }
            return;
        }
        Player finalPlayer = player;
        HotbarMenu<T> menu = openMenu.getMenu();
        Optional<MonitoredState> maybeMonitor = menu.getMonitoredState(openMenu.getState());
        if (maybeMonitor.isPresent()) {
            if (!maybeMonitor.filter(monitor -> monitor.getMonitorTimestamp() != openMenu.getMonitorTimestamp()).isPresent()) {
                if (menu.getBlinkingSlots().isPresent()) {
                    menu.getBlinkingSlots().get().stream().forEach(arg_0 -> HotbarMenuHelper.lambda$updateMenu$8(menu, openMenu, finalPlayer, (Inventory)inv, arg_0));
                }
                return;
            }
            openMenu.setMonitorTimestamp(maybeMonitor.get().getMonitorTimestamp());
        }
        menu.getIcons().forEach((arg_0, arg_1) -> HotbarMenuHelper.lambda$updateMenu$9(openMenu, finalPlayer, (Inventory)inv, arg_0, arg_1));
    }

    private static /* synthetic */ void lambda$updateMenu$9(ActiveHotbarMenu openMenu, Player finalPlayer, Inventory inv, Integer slot, Icon icon) {
        ItemStack stack = icon.build(openMenu.getState(), finalPlayer);
        ItemStack comp = inv.getItem(slot.intValue());
        if (comp == null && stack.getType() != Material.AIR || comp != null && !comp.equals((Object)stack)) {
            inv.setItem(slot.intValue(), stack);
        }
    }

    private static /* synthetic */ void lambda$updateMenu$8(HotbarMenu menu, ActiveHotbarMenu openMenu, Player finalPlayer, Inventory inv, Integer slot) {
        Icon icon = menu.getIcon(slot).get();
        ItemStack stack = icon.build(openMenu.getState(), finalPlayer);
        ItemStack comp = inv.getItem(slot.intValue());
        if (comp == null && stack.getType() != Material.AIR || comp != null && !comp.equals((Object)stack)) {
            inv.setItem(slot.intValue(), stack);
        }
    }
}

