/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.network.messaging;

import com.google.common.reflect.TypeToken;
import io.lumine.mythic.utils.interfaces.TypeAware;
import io.lumine.mythic.utils.network.messaging.ChannelAgent;
import io.lumine.mythic.utils.network.messaging.ChannelListener;
import io.lumine.mythic.utils.network.messaging.codec.Codec;
import io.lumine.mythic.utils.promise.Promise;
import javax.annotation.Nonnull;

public interface Channel<T>
extends TypeAware<T> {
    @Nonnull
    public String getName();

    @Override
    @Nonnull
    public TypeToken<T> getType();

    @Nonnull
    public Codec<T> getCodec();

    @Nonnull
    public ChannelAgent<T> newAgent();

    @Nonnull
    default public ChannelAgent<T> newAgent(ChannelListener<T> listener) {
        ChannelAgent<T> agent = this.newAgent();
        agent.addListener(listener);
        return agent;
    }

    @Nonnull
    public Promise<Void> sendMessage(@Nonnull T var1);

    @Nonnull
    public Promise<Void> sendMessage(@Nonnull String var1, @Nonnull T var2);
}

