/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.network.messaging.redis;

import com.google.common.reflect.TypeToken;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.lib.pool2.impl.GenericObjectPoolConfig;
import io.lumine.mythic.utils.logging.Log;
import io.lumine.mythic.utils.network.messaging.AbstractMessenger;
import io.lumine.mythic.utils.network.messaging.Channel;
import io.lumine.mythic.utils.network.messaging.redis.Redis;
import io.lumine.mythic.utils.network.messaging.redis.RedisCredentials;
import io.lumine.mythic.utils.plugin.LoaderUtils;
import io.lumine.mythic.utils.redis.jedis.BinaryJedisPubSub;
import io.lumine.mythic.utils.redis.jedis.Jedis;
import io.lumine.mythic.utils.redis.jedis.JedisPool;
import io.lumine.mythic.utils.redis.jedis.JedisPoolConfig;
import io.lumine.mythic.utils.redis.jedis.exceptions.JedisExhaustedPoolException;
import io.lumine.mythic.utils.terminable.composite.CompositeTerminable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class RedisImpl
implements Redis {
    private final String serverName;
    private final JedisPool pool;
    private final AbstractMessenger messenger;
    private final RedisCredentials credentials;
    private boolean closed = false;
    private PubSubListener listener = null;
    private Set<String> channels = ConcurrentHashMap.newKeySet();
    private CompositeTerminable registry = CompositeTerminable.create();

    public RedisImpl(@Nonnull String serverName, @Nonnull RedisCredentials credentials) {
        this.serverName = serverName;
        this.credentials = credentials;
        this.listener = new PubSubListener();
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(50);
        jedisPoolConfig.setMaxIdle(50);
        jedisPoolConfig.setMinIdle(10);
        jedisPoolConfig.setMaxWaitMillis(2000L);
        jedisPoolConfig.setTestOnReturn(true);
        this.pool = new JedisPool((GenericObjectPoolConfig<Jedis>)jedisPoolConfig, credentials.getAddress(), credentials.getPort());
        Log.info("Redis Pool Initialized....");
        this.openMessagingChannel("NETWORK.*");
        this.openMessagingChannel(serverName + ".*");
        Schedulers.async().runRepeating(() -> {
            int active = this.pool.getNumActive();
            int idle = this.pool.getNumIdle();
            int total = active + idle;
            Log.info(String.format("JedisPool: Active=%d, Idle=%d, Waiters=%d, total=%d, maxTotal=%d, minIdle=%d, maxIdle=%d", active, idle, this.pool.getNumWaiters(), total, jedisPoolConfig.getMaxTotal(), jedisPoolConfig.getMinIdle(), jedisPoolConfig.getMaxIdle()));
        }, 1200L, 1200L);
        LoaderUtils.getPlugin().provideService(Redis.class, this);
        this.messenger = new AbstractMessenger(serverName, (channel, message) -> {
            try (Jedis j = this.pool.getResource();){
                channel = "NETWORK." + channel;
                j.publish(channel.getBytes(StandardCharsets.UTF_8), (byte[])message);
            }
            catch (JedisExhaustedPoolException e) {
                Log.severe("ERROR: Jedis Pool is Exhausted!");
                RedisImpl.crunchifyGenerateThreadDump();
            }
        }, (server, channel, message) -> {
            try (Jedis j = this.pool.getResource();){
                channel = server + "." + channel;
                j.publish(channel.getBytes(StandardCharsets.UTF_8), (byte[])message);
            }
            catch (JedisExhaustedPoolException e) {
                Log.severe("ERROR: Jedis Pool is Exhausted!");
                RedisImpl.crunchifyGenerateThreadDump();
            }
        }, channel -> {
            String lChannel = serverName + "." + channel;
            Log.info("[lumine-redis] Would have subscribed to channel: " + lChannel);
            this.channels.add(lChannel);
            String gChannel = "NETWORK." + channel;
            Log.info("[lumine-redis] Would have subscribed to: " + gChannel);
            this.channels.add(gChannel);
        }, channel -> {
            String lChannel = serverName + "." + channel;
            Log.info("[lumine-redis] Unsubscribing from channel: " + lChannel);
            this.channels.remove(lChannel);
            String gChannel = "NETWORK." + channel;
            Log.info("[lumine-redis] Unsubscribing from channel: " + gChannel);
            this.channels.remove(gChannel);
        });
    }

    private void openMessagingChannel(String channel) {
        Schedulers.async().run(() -> {
            while (!this.closed) {
                Jedis j = this.pool.getResource();
                try {
                    Log.info("Opening messaging channel for " + channel + " class communications.");
                    j.psubscribe(this.listener, new byte[][]{channel.getBytes(StandardCharsets.UTF_8)});
                }
                finally {
                    if (j == null) continue;
                    j.close();
                }
            }
        }).bindWith(this.registry);
    }

    public static String crunchifyGenerateThreadDump() {
        ThreadInfo[] threadInfos;
        StringBuilder dump = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 1000)) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        return dump.toString();
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        if (this.listener != null) {
            this.listener.unsubscribe();
            this.listener = null;
        }
        if (this.pool != null) {
            this.pool.close();
        }
        this.registry.close();
    }

    @Override
    @Nonnull
    public <T> Channel<T> getChannel(@Nonnull String name, @Nonnull TypeToken<T> type) {
        return this.messenger.getChannel(name, type);
    }

    public String getServerName() {
        return this.serverName;
    }

    @Override
    public JedisPool getPool() {
        return this.pool;
    }

    public RedisCredentials getCredentials() {
        return this.credentials;
    }

    private final class PubSubListener
    extends BinaryJedisPubSub {
        private PubSubListener() {
        }

        @Override
        public void onPSubscribe(byte[] channel, int subscribedChannels) {
            Log.info("[lumine-redis] <MEMER> Subscribed to channel: " + new String(channel, StandardCharsets.UTF_8));
        }

        @Override
        public void onPUnsubscribe(byte[] channel, int subscribedChannels) {
            String channelName = new String(channel, StandardCharsets.UTF_8);
            Log.info("[lumine-redis] <MEMER> Unsubscribed from channel: " + channelName);
        }

        @Override
        public void onPMessage(byte[] pattern, byte[] channel, byte[] message) {
            String channelName = new String(channel, StandardCharsets.UTF_8);
            String[] spl = channelName.split("\\.");
            String server = spl[0];
            String subchannel = spl[1];
            try {
                RedisImpl.this.messenger.registerIncomingMessage(subchannel, server, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

