/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.numbers;

public final class Maths {
    private static final int SIN_BITS;
    private static final int SIN_MASK;
    private static final int SIN_COUNT;
    private static final float radFull;
    private static final float radToIndex;
    private static final float degFull;
    private static final float degToIndex;
    private static final float DISTANCE = 0.5f;
    private static final float[] sin;
    private static final float[] cos;

    public static float sin(float rad) {
        return sin[(int)(rad * radToIndex) & SIN_MASK];
    }

    public static float cos(float rad) {
        return cos[(int)(rad * radToIndex) & SIN_MASK];
    }

    public static float toRadians(double degree) {
        return (float)Math.toRadians(degree);
    }

    private Maths() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    static {
        int i;
        SIN_BITS = 12;
        SIN_MASK = ~(-1 << SIN_BITS);
        SIN_COUNT = SIN_MASK + 1;
        radFull = (float)Math.PI * 2;
        degFull = 360.0f;
        radToIndex = (float)SIN_COUNT / radFull;
        degToIndex = (float)SIN_COUNT / degFull;
        sin = new float[SIN_COUNT];
        cos = new float[SIN_COUNT];
        for (i = 0; i < SIN_COUNT; ++i) {
            Maths.sin[i] = (float)Math.sin(((float)i + 0.5f) / (float)SIN_COUNT * radFull);
            Maths.cos[i] = (float)Math.cos(((float)i + 0.5f) / (float)SIN_COUNT * radFull);
        }
        for (i = 0; i < 360; i += 90) {
            Maths.sin[(int)((float)i * Maths.degToIndex) & Maths.SIN_MASK] = (float)Math.sin((double)i * Math.PI / 180.0);
            Maths.cos[(int)((float)i * Maths.degToIndex) & Maths.SIN_MASK] = (float)Math.cos((double)i * Math.PI / 180.0);
        }
    }
}

