/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.numbers;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Numbers {
    @Nullable
    public static Number parseNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return NumberFormat.getInstance().parse(s2);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Number> parse(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseNullable(s2));
    }

    @Nullable
    public static Integer parseIntegerNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Integer> parseIntegerOpt(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseIntegerNullable(s2));
    }

    @Nonnull
    public static OptionalInt parseInteger(@Nonnull String s2) {
        try {
            return OptionalInt.of(Integer.parseInt(s2));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    @Nullable
    public static Long parseLongNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return Long.parseLong(s2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Long> parseLongOpt(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseLongNullable(s2));
    }

    @Nonnull
    public static OptionalLong parseLong(@Nonnull String s2) {
        try {
            return OptionalLong.of(Long.parseLong(s2));
        }
        catch (NumberFormatException e) {
            return OptionalLong.empty();
        }
    }

    @Nullable
    public static Float parseFloatNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return Float.valueOf(Float.parseFloat(s2));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Float> parseFloatOpt(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseFloatNullable(s2));
    }

    @Nonnull
    public static OptionalDouble parseFloat(@Nonnull String s2) {
        try {
            return OptionalDouble.of(Float.parseFloat(s2));
        }
        catch (NumberFormatException e) {
            return OptionalDouble.empty();
        }
    }

    @Nullable
    public static Double parseDoubleNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return Double.parseDouble(s2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Double> parseDoubleOpt(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseDoubleNullable(s2));
    }

    @Nonnull
    public static OptionalDouble parseDouble(@Nonnull String s2) {
        try {
            return OptionalDouble.of(Double.parseDouble(s2));
        }
        catch (NumberFormatException e) {
            return OptionalDouble.empty();
        }
    }

    @Nullable
    public static Byte parseByteNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return Byte.parseByte(s2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Byte> parseByteOpt(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseByteNullable(s2));
    }

    public static int randomInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static int randomInt(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }

    public static int randomInt(int min2, int max) {
        return ThreadLocalRandom.current().nextInt(min2, max + 1);
    }

    public static double randomDouble() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static long randomLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    public static boolean randomBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static int min(int val, int min2) {
        return Math.min(val, min2);
    }

    public static int max(int val, int min2) {
        return Math.max(val, min2);
    }

    public static int minMax(int val, int min2, int max) {
        if (val > max) {
            val = max;
        } else if (val < min2) {
            val = min2;
        }
        return val;
    }

    public static double min(double val, double min2) {
        return Math.min(val, min2);
    }

    public static double max(double val, double min2) {
        return Math.max(val, min2);
    }

    public static double minMax(double val, double min2, double max) {
        if (val > max) {
            val = max;
        } else if (val < min2) {
            val = min2;
        }
        return val;
    }

    public static int floor(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor - (int)(Double.doubleToRawLongBits(num) >>> 63);
    }

    public static int ceil(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor + (int)((Double.doubleToRawLongBits(num) ^ 0xFFFFFFFFFFFFFFFFL) >>> 63);
    }

    public static int round(double num) {
        return Numbers.floor(num + 0.5);
    }

    public static double square(double num) {
        return num * num;
    }

    public static double bias(double i, double b) {
        double p = Math.pow(1.0 - b, 3.0);
        return i * p / (i * p - i + 1.0);
    }

    public static int toInt(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public static float toFloat(Object object) {
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        try {
            return Float.valueOf(object.toString()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0.0f;
    }

    public static double toDouble(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0.0;
    }

    public static long toLong(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0L;
    }

    public static short toShort(Object object) {
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        try {
            return Short.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public static byte toByte(Object object) {
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        try {
            return Byte.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static String addCommas(int number) {
        NumberFormat format = NumberFormat.getInstance();
        format.setGroupingUsed(true);
        return format.format(number);
    }

    public static double triangularDistribution(double min2, double max, double peak) {
        double r = Numbers.randomDouble();
        if (r < (peak - min2) / (max - min2)) {
            return min2 + Math.sqrt(r * (max - min2) * (peak - min2));
        }
        return max - Math.sqrt((1.0 - r) * (max - min2) * (max - peak));
    }

    private Numbers() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

