/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.particles;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public abstract class Laser {
    protected final int distanceSquared;
    protected final int duration;
    protected boolean durationInTicks = false;
    protected Location start;
    protected Location end;
    protected Plugin plugin;
    protected BukkitRunnable main;
    protected BukkitTask startMove;
    protected BukkitTask endMove;
    protected Set<Player> show = ConcurrentHashMap.newKeySet();
    private Set<Player> seen = new HashSet<Player>();
    private List<Runnable> executeEnd = new ArrayList<Runnable>(1);

    protected Laser(Location start, Location end, int duration, int distance) {
        if (!Packets.enabled) {
            throw new IllegalStateException("The Laser Beam API is disabled. An error has occured during initialization.");
        }
        this.start = start;
        this.end = end;
        this.duration = duration;
        this.distanceSquared = distance < 0 ? -1 : distance * distance;
    }

    public Laser executeEnd(Runnable runnable) {
        this.executeEnd.add(runnable);
        return this;
    }

    public Laser durationInTicks() {
        this.durationInTicks = true;
        return this;
    }

    public void start(Plugin plugin) {
        Validate.isTrue((this.main == null ? 1 : 0) != 0, (String)"Task already started");
        this.plugin = plugin;
        this.main = new BukkitRunnable(){
            int time = 0;

            public void run() {
                try {
                    if (this.time == Laser.this.duration) {
                        this.cancel();
                        return;
                    }
                    if (!Laser.this.durationInTicks || this.time % 20 == 0) {
                        for (Player p : Laser.this.start.getWorld().getPlayers()) {
                            if (Laser.this.isCloseEnough(p.getLocation())) {
                                if (!Laser.this.show.add(p)) continue;
                                Laser.this.sendStartPackets(p, !Laser.this.seen.add(p));
                                continue;
                            }
                            if (!Laser.this.show.remove(p)) continue;
                            Laser.this.sendDestroyPackets(p);
                        }
                    }
                    ++this.time;
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                Laser.this.main = null;
                try {
                    for (Player p : Laser.this.show) {
                        Laser.this.sendDestroyPackets(p);
                    }
                    Laser.this.show.clear();
                    Laser.this.executeEnd.forEach(Runnable::run);
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }
        };
        this.main.runTaskTimerAsynchronously(plugin, 0L, this.durationInTicks ? 1L : 20L);
    }

    public void stop() {
        Validate.isTrue((this.main != null ? 1 : 0) != 0, (String)"Task not started");
        this.main.cancel();
    }

    public boolean isStarted() {
        return this.main != null;
    }

    public abstract LaserType getLaserType();

    public abstract void moveStart(Location var1) throws ReflectiveOperationException;

    public abstract void moveEnd(Location var1) throws ReflectiveOperationException;

    public Location getStart() {
        return this.start;
    }

    public Location getEnd() {
        return this.end;
    }

    public void moveStart(Location location, int ticks, Runnable callback) {
        this.startMove = this.moveInternal(location, ticks, this.startMove, this::getStart, this::moveStart, callback);
    }

    public void moveEnd(Location location, int ticks, Runnable callback) {
        this.endMove = this.moveInternal(location, ticks, this.endMove, this::getEnd, this::moveEnd, callback);
    }

    private BukkitTask moveInternal(final Location location, final int ticks, BukkitTask oldTask, final Supplier<Location> locationSupplier, final ReflectiveConsumer<Location> moveConsumer, final Runnable callback) {
        Validate.isTrue((ticks > 0 ? 1 : 0) != 0);
        Validate.isTrue((this.plugin != null ? 1 : 0) != 0, (String)"Task didn't start once");
        if (oldTask != null && !oldTask.isCancelled()) {
            oldTask.cancel();
        }
        return new BukkitRunnable(){
            double xPerTick;
            double yPerTick;
            double zPerTick;
            int elapsed;
            {
                this.xPerTick = (location.getX() - ((Location)locationSupplier.get()).getX()) / (double)ticks;
                this.yPerTick = (location.getY() - ((Location)locationSupplier.get()).getY()) / (double)ticks;
                this.zPerTick = (location.getZ() - ((Location)locationSupplier.get()).getZ()) / (double)ticks;
                this.elapsed = 0;
            }

            public void run() {
                try {
                    moveConsumer.accept(((Location)locationSupplier.get()).add(this.xPerTick, this.yPerTick, this.zPerTick));
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                    this.cancel();
                    return;
                }
                if (++this.elapsed == ticks) {
                    this.cancel();
                    if (callback != null) {
                        callback.run();
                    }
                }
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }

    protected void moveFakeEntity(Location location, int entityId, Object fakeEntity) throws ReflectiveOperationException {
        Object packet;
        if (fakeEntity == null) {
            packet = Packets.createPacketMoveEntity(location, entityId);
        } else {
            Packets.moveFakeEntity(fakeEntity, location);
            packet = Packets.createPacketMoveEntity(fakeEntity);
        }
        for (Player p : this.show) {
            Packets.sendPackets(p, packet);
        }
    }

    protected abstract void sendStartPackets(Player var1, boolean var2) throws ReflectiveOperationException;

    protected abstract void sendDestroyPackets(Player var1) throws ReflectiveOperationException;

    private boolean isCloseEnough(Location location) {
        return this.distanceSquared == -1 || this.start.distanceSquared(location) <= (double)this.distanceSquared || this.end.distanceSquared(location) <= (double)this.distanceSquared;
    }

    private static class Packets {
        private static int lastIssuedEID = 2000000000;
        private static int version;
        private static int versionMinor;
        private static String npack;
        private static String cpack;
        private static int squidID;
        private static int guardianID;
        private static int crystalID;
        private static Class<?> entityTypesClass;
        private static Object crystalType;
        private static Object squidType;
        private static Object guardianType;
        private static Object watcherObject1;
        private static Object watcherObject2;
        private static Object watcherObject3;
        private static Object watcherObject4;
        private static Constructor<?> watcherConstructor;
        private static Method watcherSet;
        private static Method watcherRegister;
        private static Method watcherDirty;
        private static Constructor<?> blockPositionConstructor;
        private static Constructor<?> packetSpawnLiving;
        private static Constructor<?> packetSpawnNormal;
        private static Constructor<?> packetRemove;
        private static Constructor<?> packetTeleport;
        private static Constructor<?> packetMetadata;
        private static Class<?> packetTeam;
        private static Method createTeamPacket;
        private static Constructor<?> createTeam;
        private static Constructor<?> createScoreboard;
        private static Method setTeamPush;
        private static Object pushNever;
        private static Method getTeamPlayers;
        private static Method getHandle;
        private static Field playerConnection;
        private static Method sendPacket;
        private static Method setLocation;
        private static Object fakeSquid;
        private static Object fakeSquidWatcher;
        private static Object nmsWorld;
        public static boolean enabled;

        private Packets() {
        }

        static int generateEID() {
            return lastIssuedEID++;
        }

        public static void sendPackets(Player p, Object ... packets) throws ReflectiveOperationException {
            Object connection = playerConnection.get(getHandle.invoke((Object)p, new Object[0]));
            for (Object packet : packets) {
                sendPacket.invoke(connection, packet);
            }
        }

        public static Object createFakeDataWatcher() throws ReflectiveOperationException {
            Object watcher = watcherConstructor.newInstance(fakeSquid);
            if (version > 13) {
                Packets.setField(watcher, "registrationLocked", false);
            }
            return watcher;
        }

        public static void setDirtyWatcher(Object watcher) throws ReflectiveOperationException {
            if (version >= 15) {
                watcherDirty.invoke(watcher, watcherObject1);
            }
        }

        public static Object createSquid(Location location) throws ReflectiveOperationException {
            Object entity = Packets.getNMSClass("world.entity.animal", "EntitySquid").getDeclaredConstructors()[0].newInstance(squidType, nmsWorld);
            Packets.moveFakeEntity(entity, location);
            return entity;
        }

        public static Object createGuardian(Location location) throws ReflectiveOperationException {
            Object entity = Packets.getNMSClass("world.entity.monster", "EntityGuardian").getDeclaredConstructors()[0].newInstance(guardianType, nmsWorld);
            Packets.moveFakeEntity(entity, location);
            return entity;
        }

        public static Object createCrystal(Location location) throws ReflectiveOperationException {
            return Packets.getNMSClass("world.entity.boss.enderdragon", "EntityEnderCrystal").getDeclaredConstructor(nmsWorld.getClass().getSuperclass(), Double.TYPE, Double.TYPE, Double.TYPE).newInstance(nmsWorld, location.getX(), location.getY(), location.getZ());
        }

        public static Object createPacketEntitySpawnLiving(Location location, int typeID) throws ReflectiveOperationException {
            Object packet = packetSpawnLiving.newInstance(new Object[0]);
            Packets.setField(packet, "a", Packets.generateEID());
            Packets.setField(packet, "b", UUID.randomUUID());
            Packets.setField(packet, "c", typeID);
            Packets.setField(packet, "d", location.getX());
            Packets.setField(packet, "e", location.getY());
            Packets.setField(packet, "f", location.getZ());
            Packets.setField(packet, "j", (byte)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(packet, "k", (byte)(location.getPitch() * 256.0f / 360.0f));
            if (version <= 14) {
                Packets.setField(packet, "m", fakeSquidWatcher);
            }
            return packet;
        }

        public static Object createPacketEntitySpawnNormal(Location location, int typeID, Object type) throws ReflectiveOperationException {
            Object packet = packetSpawnNormal.newInstance(new Object[0]);
            Packets.setField(packet, "a", Packets.generateEID());
            Packets.setField(packet, "b", UUID.randomUUID());
            Packets.setField(packet, "c", location.getX());
            Packets.setField(packet, "d", location.getY());
            Packets.setField(packet, "e", location.getZ());
            Packets.setField(packet, "i", (int)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(packet, "j", (int)(location.getPitch() * 256.0f / 360.0f));
            Packets.setField(packet, "k", version < 13 ? Integer.valueOf(typeID) : type);
            return packet;
        }

        public static Object createPacketEntitySpawnLiving(Object entity) throws ReflectiveOperationException {
            return packetSpawnLiving.newInstance(entity);
        }

        public static Object createPacketEntitySpawnNormal(Object entity) throws ReflectiveOperationException {
            return packetSpawnNormal.newInstance(entity);
        }

        public static void initGuardianWatcher(Object watcher, int squidId) throws ReflectiveOperationException {
            Packets.tryWatcherSet(watcher, watcherObject1, (byte)32);
            Packets.tryWatcherSet(watcher, watcherObject2, false);
            Packets.tryWatcherSet(watcher, watcherObject3, squidId);
        }

        public static void setCrystalWatcher(Object watcher, Location target) throws ReflectiveOperationException {
            Object blockPosition = blockPositionConstructor.newInstance(target.getX(), target.getY(), target.getZ());
            Packets.tryWatcherSet(watcher, watcherObject4, version < 13 ? com.google.common.base.Optional.of(blockPosition) : Optional.of(blockPosition));
        }

        public static Object[] createPacketsRemoveEntities(int ... entitiesId) throws ReflectiveOperationException {
            Object[] packets;
            if (version == 17 && versionMinor == 0) {
                packets = new Object[entitiesId.length];
                for (int i = 0; i < entitiesId.length; ++i) {
                    packets[i] = packetRemove.newInstance(entitiesId[i]);
                }
            } else {
                packets = new Object[]{packetRemove.newInstance(new Object[]{entitiesId})};
            }
            return packets;
        }

        public static Object createPacketMoveEntity(Location location, int entityId) throws ReflectiveOperationException {
            Object packet = packetTeleport.newInstance(new Object[0]);
            Packets.setField(packet, "a", entityId);
            Packets.setField(packet, "b", location.getX());
            Packets.setField(packet, "c", location.getY());
            Packets.setField(packet, "d", location.getZ());
            Packets.setField(packet, "e", (byte)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(packet, "f", (byte)(location.getPitch() * 256.0f / 360.0f));
            Packets.setField(packet, "g", true);
            return packet;
        }

        public static void moveFakeEntity(Object entity, Location location) throws ReflectiveOperationException {
            setLocation.invoke(entity, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()));
        }

        public static Object createPacketMoveEntity(Object entity) throws ReflectiveOperationException {
            return packetTeleport.newInstance(entity);
        }

        public static Object createPacketTeamCreate(String teamName, UUID squidUUID, UUID guardianUUID) throws ReflectiveOperationException {
            Object packet;
            if (version < 17) {
                packet = packetTeam.newInstance();
                Packets.setField(packet, "a", teamName);
                Packets.setField(packet, "i", 0);
                Packets.setField(packet, "f", "never");
                Collection players = (Collection)Packets.getField(packetTeam, "h", packet);
                players.add(squidUUID.toString());
                players.add(guardianUUID.toString());
            } else {
                Object team = createTeam.newInstance(createScoreboard.newInstance(new Object[0]), teamName);
                setTeamPush.invoke(team, pushNever);
                Collection players = (Collection)getTeamPlayers.invoke(team, new Object[0]);
                players.add(squidUUID.toString());
                players.add(guardianUUID.toString());
                packet = createTeamPacket.invoke(null, team, true);
            }
            return packet;
        }

        private static Object createPacketMetadata(int entityId, Object watcher) throws ReflectiveOperationException {
            return packetMetadata.newInstance(entityId, watcher, false);
        }

        private static void tryWatcherSet(Object watcher, Object watcherObject, Object watcherData) throws ReflectiveOperationException {
            block2: {
                try {
                    watcherSet.invoke(watcher, watcherObject, watcherData);
                }
                catch (InvocationTargetException ex) {
                    watcherRegister.invoke(watcher, watcherObject, watcherData);
                    if (version < 15) break block2;
                    watcherDirty.invoke(watcher, watcherObject);
                }
            }
        }

        private static Method getMethod(Class<?> clazz, String name) {
            for (Method m4 : clazz.getDeclaredMethods()) {
                if (!m4.getName().equals(name)) continue;
                return m4;
            }
            return null;
        }

        private static void setField(Object instance, String name, Object value) throws ReflectiveOperationException {
            Validate.notNull((Object)instance);
            Field field = instance.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(instance, value);
        }

        private static Object getField(Class<?> clazz, String name, Object instance) throws ReflectiveOperationException {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(instance);
        }

        private static Object getField(Object instance, String name) throws ReflectiveOperationException {
            Field field = instance.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return field.get(instance);
        }

        private static Class<?> getNMSClass(String package17, String className) throws ClassNotFoundException {
            return Class.forName((version < 17 ? npack : "net.minecraft." + package17) + "." + className);
        }

        static {
            npack = "net.minecraft.server." + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            cpack = Bukkit.getServer().getClass().getPackage().getName() + ".";
            crystalID = 51;
            enabled = false;
            try {
                Object[] objectArray;
                Class[] classArray;
                Class[] classArray2;
                Class[] classArray3;
                String watcherName4;
                String[] versions = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1).split("_");
                version = Integer.parseInt(versions[1]);
                versionMinor = version >= 17 ? ((versions = Bukkit.getBukkitVersion().split("-R")[0].split("\\.")).length <= 2 ? 0 : Integer.parseInt(versions[2])) : Integer.parseInt(versions[2].substring(1));
                String watcherName1 = null;
                String watcherName2 = null;
                String watcherName3 = null;
                String crystalTypeName = "END_CRYSTAL";
                if (version < 13) {
                    watcherName1 = "Z";
                    watcherName2 = "bA";
                    watcherName3 = "bB";
                    watcherName4 = "b";
                    squidID = 94;
                    guardianID = 68;
                } else if (version == 13) {
                    watcherName1 = "ac";
                    watcherName2 = "bF";
                    watcherName3 = "bG";
                    watcherName4 = "b";
                    squidID = 70;
                    guardianID = 28;
                } else if (version == 14) {
                    watcherName1 = "W";
                    watcherName2 = "b";
                    watcherName3 = "bD";
                    watcherName4 = "c";
                    squidID = 73;
                    guardianID = 30;
                } else if (version == 15) {
                    watcherName1 = "T";
                    watcherName2 = "b";
                    watcherName3 = "bA";
                    watcherName4 = "c";
                    squidID = 74;
                    guardianID = 31;
                } else if (version == 16) {
                    guardianID = 31;
                    watcherName2 = "b";
                    watcherName3 = "d";
                    watcherName4 = "c";
                    if (versionMinor < 2) {
                        watcherName1 = "T";
                        squidID = 74;
                    } else {
                        watcherName1 = "S";
                        squidID = 81;
                    }
                } else {
                    watcherName1 = "Z";
                    watcherName2 = "b";
                    watcherName3 = "e";
                    watcherName4 = "c";
                    crystalTypeName = "u";
                    squidID = 86;
                    guardianID = 35;
                }
                Class<?> entityClass = Packets.getNMSClass("world.entity", "Entity");
                entityTypesClass = Packets.getNMSClass("world.entity", "EntityTypes");
                watcherObject1 = Packets.getField(entityClass, watcherName1, null);
                watcherObject2 = Packets.getField(Packets.getNMSClass("world.entity.monster", "EntityGuardian"), watcherName2, null);
                watcherObject3 = Packets.getField(Packets.getNMSClass("world.entity.monster", "EntityGuardian"), watcherName3, null);
                watcherObject4 = Packets.getField(Packets.getNMSClass("world.entity.boss.enderdragon", "EntityEnderCrystal"), watcherName4, null);
                if (version >= 13) {
                    crystalType = entityTypesClass.getDeclaredField(crystalTypeName).get(null);
                    if (version >= 17) {
                        squidType = entityTypesClass.getDeclaredField("aJ").get(null);
                        guardianType = entityTypesClass.getDeclaredField("K").get(null);
                    }
                }
                Class<?> dataWatcherClass = Packets.getNMSClass("network.syncher", "DataWatcher");
                watcherConstructor = dataWatcherClass.getDeclaredConstructor(entityClass);
                watcherSet = Packets.getMethod(dataWatcherClass, "set");
                watcherRegister = Packets.getMethod(dataWatcherClass, "register");
                if (version >= 15) {
                    watcherDirty = Packets.getMethod(dataWatcherClass, "markDirty");
                }
                Class<?> clazz = Packets.getNMSClass("network.protocol.game", "PacketPlayOutSpawnEntityLiving");
                if (version < 17) {
                    classArray3 = new Class[]{};
                } else {
                    Class[] classArray4 = new Class[1];
                    classArray3 = classArray4;
                    classArray4[0] = Packets.getNMSClass("world.entity", "EntityLiving");
                }
                packetSpawnLiving = clazz.getDeclaredConstructor(classArray3);
                Class<?> clazz2 = Packets.getNMSClass("network.protocol.game", "PacketPlayOutSpawnEntity");
                if (version < 17) {
                    classArray2 = new Class[]{};
                } else {
                    Class[] classArray5 = new Class[1];
                    classArray2 = classArray5;
                    classArray5[0] = Packets.getNMSClass("world.entity", "Entity");
                }
                packetSpawnNormal = clazz2.getDeclaredConstructor(classArray2);
                packetRemove = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityDestroy").getDeclaredConstructor(version == 17 && versionMinor == 0 ? Integer.TYPE : int[].class);
                packetMetadata = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityMetadata").getDeclaredConstructor(Integer.TYPE, dataWatcherClass, Boolean.TYPE);
                Class<?> clazz3 = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityTeleport");
                if (version < 17) {
                    classArray = new Class[]{};
                } else {
                    Class[] classArray6 = new Class[1];
                    classArray = classArray6;
                    classArray6[0] = entityClass;
                }
                packetTeleport = clazz3.getDeclaredConstructor(classArray);
                packetTeam = Packets.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam");
                blockPositionConstructor = Packets.getNMSClass("core", "BlockPosition").getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
                nmsWorld = Class.forName(cpack + "CraftWorld").getDeclaredMethod("getHandle", new Class[0]).invoke(Bukkit.getWorlds().get(0), new Object[0]);
                if (version < 14) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = nmsWorld;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = Packets.getNMSClass("world.entity", "EntityTypes").getDeclaredField(version < 17 ? "SQUID" : "aJ").get(null);
                    objectArray = objectArray3;
                    objectArray3[1] = nmsWorld;
                }
                Object[] entityConstructorParams = objectArray;
                fakeSquid = Packets.getNMSClass("world.entity.animal", "EntitySquid").getDeclaredConstructors()[0].newInstance(entityConstructorParams);
                fakeSquidWatcher = Packets.createFakeDataWatcher();
                Packets.tryWatcherSet(fakeSquidWatcher, watcherObject1, (byte)32);
                getHandle = Class.forName(cpack + "entity.CraftPlayer").getDeclaredMethod("getHandle", new Class[0]);
                playerConnection = Packets.getNMSClass("server.level", "EntityPlayer").getDeclaredField(version < 17 ? "playerConnection" : "b");
                sendPacket = Packets.getNMSClass("server.network", "PlayerConnection").getMethod("sendPacket", Packets.getNMSClass("network.protocol", "Packet"));
                if (version >= 17) {
                    setLocation = entityClass.getDeclaredMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
                    createTeamPacket = packetTeam.getMethod("a", Packets.getNMSClass("world.scores", "ScoreboardTeam"), Boolean.TYPE);
                    Class<?> scoreboardClass = Packets.getNMSClass("world.scores", "Scoreboard");
                    Class<?> teamClass = Packets.getNMSClass("world.scores", "ScoreboardTeam");
                    Class<?> pushClass = Packets.getNMSClass("world.scores", "ScoreboardTeamBase$EnumTeamPush");
                    createTeam = teamClass.getDeclaredConstructor(scoreboardClass, String.class);
                    createScoreboard = scoreboardClass.getDeclaredConstructor(new Class[0]);
                    setTeamPush = teamClass.getDeclaredMethod("setCollisionRule", pushClass);
                    pushNever = pushClass.getDeclaredField("b").get(null);
                    getTeamPlayers = teamClass.getDeclaredMethod("getPlayerNameSet", new Class[0]);
                }
                enabled = true;
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
                System.err.println("Laser Beam reflection failed to initialize. The util is disabled. Please ensure your version (" + Bukkit.getServer().getClass().getPackage().getName() + ") is supported.");
            }
        }
    }

    @FunctionalInterface
    public static interface ReflectiveConsumer<T> {
        public void accept(T var1) throws ReflectiveOperationException;
    }

    public static enum LaserType {
        GUARDIAN,
        ENDER_CRYSTAL;


        public Laser create(Location start, Location end, int duration, int distance) throws ReflectiveOperationException {
            switch (this) {
                case ENDER_CRYSTAL: {
                    return new CrystalLaser(start, end, duration, distance);
                }
                case GUARDIAN: {
                    return new GuardianLaser(start, end, duration, distance);
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class CrystalLaser
    extends Laser {
        private Object createCrystalPacket;
        private Object metadataPacketCrystal;
        private Object[] destroyPackets;
        private Object fakeCrystalDataWatcher = Packets.createFakeDataWatcher();
        private Object crystal;
        private int crystalID;

        public CrystalLaser(Location start, Location end, int duration, int distance) throws ReflectiveOperationException {
            super(start, end, duration, distance);
            Packets.setCrystalWatcher(this.fakeCrystalDataWatcher, end);
            if (Packets.version < 17) {
                this.crystal = null;
                this.createCrystalPacket = Packets.createPacketEntitySpawnNormal(start, Packets.crystalID, Packets.crystalType);
            } else {
                this.crystal = Packets.createCrystal(start);
                this.createCrystalPacket = Packets.createPacketEntitySpawnNormal(this.crystal);
            }
            this.crystalID = (Integer)Packets.getField(this.createCrystalPacket, Packets.version < 17 ? "a" : "c");
            this.metadataPacketCrystal = Packets.createPacketMetadata(this.crystalID, this.fakeCrystalDataWatcher);
            this.destroyPackets = Packets.createPacketsRemoveEntities(this.crystalID);
        }

        @Override
        public LaserType getLaserType() {
            return LaserType.ENDER_CRYSTAL;
        }

        @Override
        protected void sendStartPackets(Player p, boolean hasSeen) throws ReflectiveOperationException {
            Packets.sendPackets(p, this.createCrystalPacket);
            Packets.sendPackets(p, this.metadataPacketCrystal);
        }

        @Override
        protected void sendDestroyPackets(Player p) throws ReflectiveOperationException {
            Packets.sendPackets(p, this.destroyPackets);
        }

        @Override
        public void moveStart(Location location) throws ReflectiveOperationException {
            this.start = location;
            if (this.main != null) {
                this.moveFakeEntity(this.start, this.crystalID, this.crystal);
            }
        }

        @Override
        public void moveEnd(Location location) throws ReflectiveOperationException {
            this.end = location;
            if (this.main != null) {
                Packets.setCrystalWatcher(this.fakeCrystalDataWatcher, location);
                this.metadataPacketCrystal = Packets.createPacketMetadata(this.crystalID, this.fakeCrystalDataWatcher);
                for (Player p : this.show) {
                    Packets.sendPackets(p, this.metadataPacketCrystal);
                }
            }
        }
    }

    public static class GuardianLaser
    extends Laser {
        private static int teamID = ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE);
        private final Object createGuardianPacket;
        private final Object createSquidPacket;
        private final Object teamCreatePacket;
        private final Object[] destroyPackets;
        private final Object metadataPacketGuardian;
        private final Object metadataPacketSquid;
        private final Object fakeGuardianDataWatcher;
        private final Object squid;
        private final int squidID;
        private final UUID squidUUID;
        private final Object guardian;
        private final int guardianID;
        private final UUID guardianUUID;

        public GuardianLaser(Location start, Location end, int duration, int distance) throws ReflectiveOperationException {
            super(start, end, duration, distance);
            if (Packets.version < 17) {
                this.squid = null;
                this.createSquidPacket = Packets.createPacketEntitySpawnLiving(end, Packets.squidID);
            } else {
                this.squid = Packets.createSquid(end);
                this.createSquidPacket = Packets.createPacketEntitySpawnLiving(this.squid);
            }
            this.squidID = (Integer)Packets.getField(this.createSquidPacket, "a");
            this.squidUUID = (UUID)Packets.getField(this.createSquidPacket, "b");
            this.metadataPacketSquid = Packets.createPacketMetadata(this.squidID, Packets.fakeSquidWatcher);
            Packets.setDirtyWatcher(Packets.fakeSquidWatcher);
            this.fakeGuardianDataWatcher = Packets.createFakeDataWatcher();
            Packets.initGuardianWatcher(this.fakeGuardianDataWatcher, this.squidID);
            if (Packets.version < 17) {
                this.guardian = null;
                this.createGuardianPacket = Packets.createPacketEntitySpawnLiving(start, Packets.guardianID);
            } else {
                this.guardian = Packets.createGuardian(start);
                this.createGuardianPacket = Packets.createPacketEntitySpawnLiving(this.guardian);
            }
            this.guardianID = (Integer)Packets.getField(this.createGuardianPacket, "a");
            this.guardianUUID = (UUID)Packets.getField(this.createGuardianPacket, "b");
            this.metadataPacketGuardian = Packets.createPacketMetadata(this.guardianID, this.fakeGuardianDataWatcher);
            this.teamCreatePacket = Packets.createPacketTeamCreate("noclip" + teamID++, this.squidUUID, this.guardianUUID);
            this.destroyPackets = Packets.createPacketsRemoveEntities(this.squidID, this.guardianID);
        }

        @Override
        public LaserType getLaserType() {
            return LaserType.GUARDIAN;
        }

        @Override
        protected void sendStartPackets(Player p, boolean hasSeen) throws ReflectiveOperationException {
            Packets.sendPackets(p, this.createSquidPacket, this.createGuardianPacket);
            Packets.sendPackets(p, this.metadataPacketSquid, this.metadataPacketGuardian);
            if (!hasSeen) {
                Packets.sendPackets(p, this.teamCreatePacket);
            }
        }

        @Override
        protected void sendDestroyPackets(Player p) throws ReflectiveOperationException {
            Packets.sendPackets(p, this.destroyPackets);
        }

        @Override
        public void moveStart(Location location) throws ReflectiveOperationException {
            this.start = location;
            if (this.main != null) {
                this.moveFakeEntity(this.start, this.guardianID, this.guardian);
            }
        }

        @Override
        public void moveEnd(Location location) throws ReflectiveOperationException {
            this.end = location;
            if (this.main != null) {
                this.moveFakeEntity(this.end, this.squidID, this.squid);
            }
        }

        public void callColorChange() throws ReflectiveOperationException {
            for (Player p : this.show) {
                Packets.sendPackets(p, this.metadataPacketGuardian);
            }
        }
    }
}

