/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.particles;

import io.lumine.mythic.utils.logging.Log;
import io.lumine.mythic.utils.particles.ParticleBuilder;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public enum Particle {
    EXPLOSION_NORMAL("poof", "explode", "explosion", "explosion_small"),
    EXPLOSION_LARGE("largeexplode", "largeexplosion"),
    EXPLOSION_HUGE("explosion_emitter", "hugeexplode", "hugeexplosion"),
    FIREWORKS_SPARK("firework", "fireworksspark"),
    WATER_BUBBLE("bubble"),
    WATER_SPLASH("splash"),
    WATER_WAKE("fishing", "wake"),
    SUSPENDED("underwater"),
    SUSPENDED_DEPTH("underwater", "depthsuspend"),
    CRIT("crit"),
    CRIT_MAGIC("enchanted_hit", "magiccrit"),
    SMOKE_NORMAL("smoke"),
    SMOKE_LARGE("large_smoke", "largesmoke"),
    SPELL("effect"),
    SPELL_INSTANT("instant_effect", "instantSpell"),
    SPELL_MOB("entity_effect", "mobSpell"),
    SPELL_MOB_AMBIENT("ambient_entity_effect", "mobSpellAmbient"),
    SPELL_WITCH("witch", "witchMagic"),
    DRIP_WATER("dripping_water", "dripWater"),
    DRIP_LAVA("dripping_lava", "dripLava"),
    VILLAGER_ANGRY("angry_villager", "angryVillager"),
    VILLAGER_HAPPY("happy_villager", "happyVillager"),
    TOWN_AURA("mycelium", "townaura"),
    NOTE("note"),
    PORTAL("portal"),
    ENCHANTMENT_TABLE("enchant", "enchantmenttable", "enchantingtable"),
    FLAME("flame"),
    LAVA("lava"),
    CLOUD("cloud"),
    REDSTONE("dust", "reddust"),
    SNOWBALL("item_snowball", "snowballpoof"),
    SNOW_SHOVEL("item_snowball", "snowshovel"),
    SLIME("item_slime"),
    HEART("heart"),
    BARRIER("barrier"),
    ITEM_CRACK("item", "iconcrack", "itemcrack"),
    BLOCK_CRACK("block", "blockcrack"),
    BLOCK_DUST("dust", "blockdust"),
    WATER_DROP("rain", "droplet"),
    MOB_APPEARANCE("elder_guardian", "mobappearance"),
    DRAGON_BREATH("dragon_breath", "dragonbreath"),
    END_ROD("end_rod", "endRod"),
    DAMAGE_INDICATOR("damage_indicator", "damageIndicator"),
    SWEEP_ATTACK("sweep_attack", "sweepAttack"),
    FALLING_DUST("falling_dust", "fallingDust"),
    TOTEM("totem_of_undying"),
    SPIT("spit"),
    SQUID_INK("squid_ink", "squidink"),
    BUBBLE_POP("bubble_pop", "bubblepop"),
    CURRENT_DOWN("current_down", "currentdown"),
    BUBBLE_COLUMN_UP("bubble_column_up", "bubblecolumn", "bubble_column"),
    NAUTILUS("nautilus"),
    DOLPHIN("dolphin"),
    COMPOSTER("composter"),
    FALLING_LAVA("fallinglava", "falling_lava"),
    FALLING_WATER("fallingwater", "falling_water"),
    FLASH("flash"),
    LANDING_LAVA("landinglava", "landing_lava"),
    SNEEZE("sneeze"),
    CAMPFIRE_COSY_SMOKE("campfire_cosy_smoke", "campfire_cosy", "campfire_cozy_smoke", "campfire_cozy", "campfire"),
    CAMPFIRE_SIGNAL_SMOKE("campfire_signal_smoke", "campfire_signal"),
    DRIPPING_HONEY("drippinghoney"),
    FALLING_HONEY("fallinghoney"),
    FALLING_NECTAR("fallingnectar"),
    LANDING_HONEY("landinghoney");

    private static final Map<String, Particle> PARTICLE_ALIASES;
    private final String[] aliases;

    public static Particle fromString(String key) {
        Particle particle = PARTICLE_ALIASES.getOrDefault(key.toUpperCase(), null);
        if (particle == null) {
            Log.error("Particle '" + key + "' is not supported by this version.");
            return CLOUD;
        }
        return particle;
    }

    private Particle(String ... aliases) {
        this.aliases = aliases;
    }

    public ParticleBuilder create() {
        return ParticleBuilder.of(this);
    }

    public org.bukkit.Particle toBukkitParticle() {
        return org.bukkit.Particle.valueOf((String)this.toString());
    }

    public boolean requiresData() {
        return !this.toBukkitParticle().getDataType().equals(Void.class);
    }

    public boolean isDustParticle() {
        return this.toBukkitParticle().getDataType() == Particle.DustOptions.class;
    }

    public boolean validateData(Object obj) {
        org.bukkit.Particle particle = this.toBukkitParticle();
        if (particle.getDataType().equals(Void.class)) {
            return false;
        }
        if (particle.getDataType().equals(ItemStack.class)) {
            return obj instanceof ItemStack;
        }
        if (particle.getDataType() == BlockData.class) {
            return obj instanceof BlockData;
        }
        if (particle.getDataType() == MaterialData.class) {
            return obj instanceof MaterialData;
        }
        if (particle.getDataType() == Particle.DustOptions.class) {
            return obj instanceof Particle.DustOptions;
        }
        return true;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    static {
        PARTICLE_ALIASES = new HashMap<String, Particle>();
        for (Particle particle : Particle.values()) {
            PARTICLE_ALIASES.put(particle.toString(), particle);
            for (String alias : particle.getAliases()) {
                PARTICLE_ALIASES.put(alias.toUpperCase(), particle);
            }
        }
    }
}

