/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.profiles;

import io.lumine.mythic.utils.profiles.Profile;
import io.lumine.mythic.utils.promise.Promise;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;

public interface ProfileRepository {
    @Nonnull
    public Profile getProfile(@Nonnull UUID var1);

    @Nonnull
    public Optional<Profile> getProfile(@Nonnull String var1);

    @Nonnull
    public Collection<Profile> getKnownProfiles();

    @Nonnull
    default public Map<UUID, Profile> getProfiles(@Nonnull Iterable<UUID> uniqueIds) {
        Objects.requireNonNull(uniqueIds, "uniqueIds");
        HashMap<UUID, Profile> ret = new HashMap<UUID, Profile>();
        for (UUID uniqueId : uniqueIds) {
            Profile profile = this.getProfile(uniqueId);
            if (!profile.getName().isPresent()) continue;
            ret.put(uniqueId, profile);
        }
        return ret;
    }

    @Nonnull
    default public Map<String, Profile> getProfilesByName(@Nonnull Iterable<String> names) {
        Objects.requireNonNull(names, "names");
        HashMap<String, Profile> ret = new HashMap<String, Profile>();
        for (String name : names) {
            this.getProfile(name).ifPresent(p -> ret.put(name, (Profile)p));
        }
        return ret;
    }

    @Nonnull
    public Promise<Profile> lookupProfile(@Nonnull UUID var1);

    @Nonnull
    public Promise<Optional<Profile>> lookupProfile(@Nonnull String var1);

    @Nonnull
    public Promise<Collection<Profile>> lookupKnownProfiles();

    @Nonnull
    public Promise<Map<UUID, Profile>> lookupProfiles(@Nonnull Iterable<UUID> var1);

    @Nonnull
    public Promise<Map<String, Profile>> lookupProfilesByName(@Nonnull Iterable<String> var1);
}

